/*
  http_pro.js - misc JS code for waf_http_pro_par_res.c
  init Mar 2011 by Jianjiang Yan
  GUI redesign project
  Copyright Fortinet Inc
*/
// http_pro_handle_selection_change - enable/disable the password button
// according to the current selection.
function http_pro_handle_selection_change(q)
{
    // Let the default handler handle the standard buttons.
    qlist_handle_selection_change(q);

    var aElems = q.get_checked_rows();
	
    if(!is_rw_admin)
    {
	qmenu_enable_button($("mi_view"), true, q);
	return;
    }

    if(aElems.length == 1 && parseInt(aElems[0].getAttribute("can_clone")) == 1)
	    qmenu_enable_button($("mi_clone"), true, q);
    else
	    qmenu_enable_button($("mi_clone"), false, q);

    if (aElems.length == 1 && parseInt(aElems[0].getAttribute("can_view")) == 1)
    {
	    qmenu_enable_button($("mi_view"), true, q);
	    qmenu_enable_button($("mi_edit"), false, q);
    }else{
	    qmenu_enable_button($("mi_view"), false, q);
	    //        qmenu_enable_button($("mi_edit"), true, q);
    }
}

// http_pro_menu - Override the default menubar to add buttons "Generate",
//             "Import", "View", "Download" and "Edit Commones".
function http_pro_menu(aItems)
{
    if (can_clone && is_rw_admin) {
	//var mNew = Page.createMenuItem({id:"mi_del", spriteClass:"tool_delete", ctxt:true, 
	//		   text:http_pro_strtbl.del, click:{fn: waf_http_pro_delete_elems} } );
        //aItems.push(mNew);
        var mNew = Page.createMenuItem({id:"mi_view", spriteClass:"tool_view", ctxt:true,
                   text:http_pro_strtbl.view, click:{fn: http_pro_onclick_view} });
        aItems.push(mNew);
        var mNew = Page.createMenuItem({id:"mi_clone", spriteClass:"tool_clone", ctxt:true,
                   text:http_pro_strtbl.clone, click:{fn: http_pro_onclick_clone} });
        aItems.push(mNew);
    }
}
function http_pro_onclick_clone()
{   
    var q = qlist_obj; // It would be cleaner if we could derive this from the event.

    var aElems = q.get_checked_rows();
    if (aElems.length != 1) return;

    var mkey = aElems[0].getAttribute("mkey");
    window.location.href = "/waf/http_pro_par_res/dlgcopy?mkey=" + mkey + "&vdom=" + vdom;	
}
/*
	 http_pro_type:control  waf_http_pro_control.c
	 http_pro_type:web	     waf_web_http_pro.c   
*/
function http_pro_onclick_view()
{   
    var q = qlist_obj; // It would be cleaner if we could derive this from the event.

    var aElems = q.get_checked_rows();
    if (aElems.length != 1) return;

    var mkey = aElems[0].getAttribute("mkey");
    window.location.href = "/waf/http_pro_par_res/dlg?mkey=" + mkey + "&vdom=" + vdom;	
}

function waf_http_pro_delete_elems(q,aElems){
	var url = "/delete?id=" + g_cmdb_table_id;
	var len = aElems.length;
	for(var i=0;i<len;i++){
		var mkey = encodeURIComponent(aElems[i].getAttribute("mkey"));
		url += "&mkey=" + mkey;
	}
	url += "&session_id="+session_id + "&vdom=" + vdom;
	$j.submitPOST(url);
}

// http_prolist_onload - onload handler for the interface list page.
function http_prolist_onload()
{
    // Customize the qlist definition.
    qlist_obj.customize_menu_fn = http_pro_menu;
    qlist_obj.delete_elems_fn = waf_http_pro_delete_elems;
    qlist_obj.handle_selection_change_fn = http_pro_handle_selection_change;

    qlist_setup("qlist", http_pro_edit_url, http_pro_edit_url,false);
}
hlight_table('qlist', 1, 0, 'over');

addEvent(window, "load", http_prolist_onload);
