/*
   input_rule.js - misc JS code for waf_input_rule.c
   init Nov 2013 by KaiLiu
   GUI redesign project
   Copyright Fortinet Inc
 */

// according to the current selection.
function inputrule_handle_selection_change(q)
{
	// Let the default handler handle the standard buttons.
	qlist_handle_selection_change(q);

	var aElems = q.get_checked_rows();

	if(is_rw_admin && aElems.length > 0)
	{
		qmenu_enable_button($("mi_action"), true, q);
		qmenu_enable_button($("mi_trigger"), true, q);
		qmenu_enable_button($("mi_severity"), true, q);
	}
	else
	{
		qmenu_enable_button($("mi_action"), false, q);
		qmenu_enable_button($("mi_trigger"), false, q);
		qmenu_enable_button($("mi_severity"), false, q);
	}

	return;
}

// inputrule_menu - Override the default menubar to add buttons "Edit Action", "Edit Trigger Policy", "Edit Severity"
function inputrule_menu(aItems)
{
	var action_menu = [{text:input_strtbl.action_alert,val:"2"},{text:input_strtbl.action_alert_deny,val:"6"},{text:input_strtbl.action_period_block,val:"11"},
	    {text:input_strtbl.action_redirect,val:"3"},{text:input_strtbl.action_send_403,val:"10"}];

	var severity_menu = [{text:input_strtbl.sev_high,val:1},{text:input_strtbl.sev_medium,val:2},{text:input_strtbl.sev_low,val:3}];
	var subItem = [];
	var Item;
	var i = 0;

	if (is_rw_admin) {
		/* add action sub menu */
		var mAction = Page.createMenuItem({id:"mi_action", spriteClass:"tool_edit", ctxt:false,
				text:input_strtbl.edit_action, label: input_strtbl.edit_action });

		for(i = 0; i < action_menu.length ; i++){
			Item = Page.createMenuItem({id:"mi_action_"+action_menu[i].val, ctxt: false,
					text:action_menu[i].text, click:{fn: inputrule_onclick_action }});
			subItem.push(Item);						
		}
		mAction.addSubMenu("mi_action",subItem);
		aItems.push(mAction);

		/* add trigger sub menu */
		subItem = [];
		var mTrigger = Page.createMenuItem({id: "mi_trigger", spriteClass: "tool_edit", ctxt: false, 
				text: input_strtbl.edit_trigger, label: input_strtbl.edit_trigger});		
		for(i = 0; i < trigger_policy.length ; i++){
			Item = Page.createMenuItem({id:"mi_trigger_"+trigger_policy[i].value, ctxt: false,
					text:trigger_policy[i].text, click:{fn: inputrule_onclick_trigger }});
			subItem.push(Item);						
		}
		mTrigger.addSubMenu("mi_trigger",subItem);
		aItems.push(mTrigger);

		/* add severity sub menu */
		subItem = [];
		var mSeverity = Page.createMenuItem({id: "mi_severity", spriteClass: "tool_edit", ctxt: false,
				text: input_strtbl.edit_severity, label: input_strtbl.edit_severity});
		for(i = 0 ;i<severity_menu.length ;i++)
		{
			Item = Page.createMenuItem({id:"mi_severity_"+severity_menu[i].val, ctxt: false,
					text:severity_menu[i].text, click:{fn: inputrule_onclick_severity }});
			subItem.push(Item);		
		}
		mSeverity.addSubMenu("mi_severity",subItem);
		aItems.push(mSeverity);

	}
}

function inputrule_onclick_action()
{
	var action_id = this.id.split("mi_action_")[1];
	var q = qlist_obj; // It would be cleaner if we could derive this from the event.
	var url = "/waf/input_rule/change?type=1&action="+action_id+"&session_id="+session_id+"&vdom="+vdom;
	var aElems = q.get_checked_rows();
	if (aElems.length < 1) return;

	for(var i = 0 ; i < aElems.length ; i++)
	{
		url += "&mkey=" + aElems[i].getAttribute("mkey");
	}
	$j.submitPOST(url);
}

function inputrule_onclick_trigger()
{
	var trigger_id = this.id.split("mi_trigger_")[1];
	var q = qlist_obj; // It would be cleaner if we could derive this from the event.
	var url = "/waf/input_rule/change?type=2&trigger="+trigger_id+"&session_id="+session_id+"&vdom="+vdom;
	var aElems = q.get_checked_rows();
	if (aElems.length < 1) return;

	for(var i = 0 ; i < aElems.length ; i++)
	{
		url += "&mkey=" + aElems[i].getAttribute("mkey");
	}
	$j.submitPOST(url);
}

function inputrule_onclick_severity()
{
	var severity_id = this.id.split("mi_severity_")[1];
	var q = qlist_obj; // It would be cleaner if we could derive this from the event.
	var url = "/waf/input_rule/change?type=3&severity="+severity_id+"&session_id="+session_id+"&vdom="+vdom;
	var aElems = q.get_checked_rows();
	if (aElems.length < 1) return;

	for(var i = 0 ; i < aElems.length ; i++)
	{
		url += "&mkey=" + aElems[i].getAttribute("mkey");
	}
	$j.submitPOST(url);
}

function waf_inputrule_delete_elems(q,aElems){
	var url = "/delete?id=" + g_cmdb_table_id;
	var len = aElems.length;
	for(var i=0;i<len;i++){
		var mkey = encodeURIComponent(aElems[i].getAttribute("mkey"));
		url += "&mkey=" + mkey;
	}
	if(vdom != "")
	{
		url += "&vdom=" + vdom;
	}
	url += "&session_id="+session_id;
	$j.submitPOST(url);
}

// inputrulelist_onload - onload handler for the input rule list page.
function inputrulelist_onload()
{
	// Customize the qlist definition.
	qlist_obj.customize_menu_fn = inputrule_menu;
	qlist_obj.handle_selection_change_fn = inputrule_handle_selection_change;
	qlist_obj.delete_elems_fn = waf_inputrule_delete_elems;

	qlist_setup("qlist", post_url, post_url, false);
	//qlist_setup("qlist", "/waf/input_rule/dlg", "/waf/input_rule/dlg",false);
}

hlight_table('qlist', 1, 0, 'over');

addEvent(window, "load", inputrulelist_onload);
