var module_list = (function($) {
	'use strict';

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function lang_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data);
	}

	function gen_qlist(datas){
		var settings = {
			'prefix': 'allow_method_policy',
			'source': datas,
//			'handle_selection_change': selection_changed,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name',flt_lang)},
				{'selector': 'severity', 'lang_key': $j.getInfo('severity',flt_lang)},
				{'selector': 'triggered-action', 'lang_key': $j.getInfo('trigger',flt_lang)},
				{'selector': 'allow-method-exception', 'lang_key': $j.getInfo('exception',flt_lang)},
			],
			'column_filters': {
				'enabled': false
			},
			'options': {
				'ref_column': false,
				'sorting': false,
			},
			'default_columns':['id', 'name', 'severity', 'triggered-action', 'allow-method-exception'],
			'format_fn': {
				'severity': lang_format_fn,
			},
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom, _: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/waf/allow_method_policy/list?vdom='+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
