var module_list = (function($) {
	'use strict';
	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}
	function status_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return data.replace(data[0],data[0].toUpperCase());
	}	
	function lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data, flt_lang);
	}
	function url_prefix_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		if(!data) return ;
		var text = "";
		var len = data.length;
		for(var i = 0; i < len;i++)
		{
			if(i!==0) text +=', ';
			text += data[i].frontend_prefix;
		}
		return text;
	}
	function gen_qlist(datas) {
		
		var settings = {
			'prefix': 'api_rule',
			'source': datas,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name', flt_lang)},
				{'selector': 'host', 'lang_key': $j.getInfo('host', flt_lang)},
				{'selector': 'url_prefix', 'lang_key': $j.getInfo('url_prefix', flt_lang)},
				{'selector': 'api_key_verify', 'lang_key': $j.getInfo('api_key_verification', flt_lang)},
				{'selector': 'allow_user_group', 'lang_key': $j.getInfo('allow_user_group', flt_lang)}
			],
			'column_filters': {
				'enabled': false,
			},
			'paging': {
				'enabled': false,
			},
			'options': {
				'ref_column': false,
				'sorting': false
			},
            'callbacks': {
                'load': content_loaded
            },
			'default_columns':['id', 'name', 'host', 'url_prefix', 'api_key_verify', 'allow_user_group'],
			'search': { 'enabled': false },
			'format_fn': {
				'url_prefix': url_prefix_format_fn,
				'api_key_verify':status_format_fn
			},
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/waf/api_rule/list_json', {table_gid:g_cmdb_table_id,vdom:vdom,_: new Date().getTime()},function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/waf/api_rule/list?vdom='+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
