var module_list = (function($) {
	'use strict';
	
	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}
	
	function lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data, flt_lang);
	}
	
	function gen_qlist(datas) {
		var settings = {
			'prefix': 'bot_client_rule',
			'source': datas,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name', flt_lang)},
				{'selector': 'mouse-movement', 'lang_key': $j.getInfo('mouse_movement', flt_lang)},
				{'selector': 'click', 'lang_key': $j.getInfo('click', flt_lang)},
				{'selector': 'keyboard', 'lang_key': $j.getInfo('keyboard', flt_lang)},
				{'selector': 'screen-touch', 'lang_key': $j.getInfo('screen_touch', flt_lang)},
				{'selector': 'scroll', 'lang_key': $j.getInfo('scroll', flt_lang)},
				{'selector': 'event-collection-time', 'lang_key': $j.getInfo('collection_time', flt_lang)},
				{'selector': 'bot-effective-time', 'lang_key': $j.getInfo('effective_time', flt_lang)},
				{'selector': 'action', 'lang_key': $j.getInfo('action', flt_lang)},
				{'selector': 'severity', 'lang_key': $j.getInfo('severity', flt_lang)},
				{'selector': 'trigger', 'lang_key': $j.getInfo('trigger', flt_lang)},
				{'selector': 'sz_url-list', 'lang_key': $j.getInfo('count', flt_lang)}
			],
			'column_filters': {
				'enabled': false,
			},
			'paging': {
				'enabled': false,
			},
			'options': {
				'ref_column': false,
				'sorting': false
			},
			'callbacks': {
				'load': content_loaded
			},
			'default_columns':['id', 'name', 'event-collection-time', 'bot-effective-time', 'action', 'severity', 'trigger', 'sz_url-list'],
			'search': { 'enabled': false },
			'format_fn': {
				'mouse-movement': lang_format_fn,
				'click': lang_format_fn,
				'keyboard': lang_format_fn,
				'screen-touch': lang_format_fn,
				'scroll': lang_format_fn,
				'action': lang_format_fn,
				'severity': lang_format_fn,
			},
		};

		var $container = $("#content");

		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom,_: new Date().getTime()},function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/waf/bot_client_rule/list?vdom='+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
