var module_list = (function($) {
        'use strict';

        var source;

        function setup_qlist()
        {
                $.ajax({
                        'url': '/system/cert_ca/list/json',
                        'dataType': 'json',
                        'success': function(response)
                        {
                                if(response.status == 1)
                                {
                                        source = response.results;
                                        gen_qlist();
                                }
                                else if(response.status == 0)
                                        error_handler(response.msg_id, "/system/cert_ca/list");
                        },
                        'cache': false
                });
        }

	function cert_onclick_import()
        {
                window.location.href = "/system/caimport";
        }

        function cert_onclick_view(qlist, elems)
        {
                var mkey = qlist_get_row_attr(elems, 'mkey');
                window.location.href = "/sys/cert/caview?q=2&seq=" + mkey;
        }

	function cert_handle_selection_change(qlist)
        {
                qlist_handle_selection_change(qlist);

                var mi_import = $('#mi_import_' + qlist.prefix);
                var mi_view = $('#mi_view_' + qlist.prefix);

                var aElems = qlist.get_checked_rows();

                qmenu_enable_button(mi_import, true, qlist);

                if (aElems.length == 1)
                        qmenu_enable_button(mi_view, true, qlist);
                else
                        qmenu_enable_button(mi_view, false, qlist);
        }

	function content_loaded(qlist)
        {
                qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
        }

	function gen_qlist(){
                var menu_items;
                if(is_rw_admin)
                {
                        menu_items = {
                                'mi_import': {
                                        'id': 'mi_import',
                                        'label': cert_strtbl.importstr,
                                        'class': 'tool_import',
                                        'handler': cert_onclick_import,
                                        'ctxt': false
                                },
                                'mi_view': {
                                        'id': 'mi_view',
                                        'label': cert_strtbl.view,
                                        'class': 'tool_view',
                                        'handler': cert_onclick_view
                                }
                        };
                }

		else
                {
                        menu_items = {
                                'mi_view': {
                                        'id': 'mi_view',
                                        'label': cert_strtbl.view,
                                        'class': 'tool_view',
                                        'handler': cert_onclick_view
                                }
                        };
                }

		var qlist_settings = {
                        'prefix': 'ca_cert',
                        'source': source,
                        'row_attr': [
                                {name: 'mkey', selector: 'name'},
                                {name: 'q_ref', selector: 'q_ref'},
                        ],
                        'columns': [
                                {'selector': 'name', 'lang_key': $j.getInfo("cert_name",flt_lang)},
                                {'selector': 'subject', 'lang_key': $j.getInfo("cert_subject",flt_lang)},
                                {'selector': 'issuer', 'lang_key': $j.getInfo("cert_issuer",flt_lang)},
                                {'selector': 'expires', 'lang_key': $j.getInfo('cert_edate', flt_lang)}
                        ],
                        'default_columns':['name', 'subject', 'issuer', 'expires'],
                        'column_filters': {
                                'enabled': true,
                                'exempts': ['expires']
                        },
                        'menu_items': menu_items,
                        'handle_selection_change': cert_handle_selection_change,
                        'options': {
                                'hide_create_button': true,
                                'hide_edit_button': true
                        },
                        'callbacks': {
                                'load': content_loaded
                        }
                };

                var $container = $("#content");
                $container.qlist(qlist_settings);

        }

	return {configure: setup_qlist};

})(jQuery);
