var module_list = (function($) {
        'use strict';

	var source;

	function setup_qlist()
	{
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id, _: new Date().getTime()},function(results) {
			if(results.status == 1) {
				source = results.datas;
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/system/cert_cagroup/list');
			}
		});
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
        }

	function gen_qlist(){
                var qlist_settings = {
                        'prefix': 'ca_group',
                        'source': source,
                        'cr_new_url': create_url,
                        'cr_edit_url': edit_url,
                        'row_attr': [
                                {name: 'mkey', selector: 'name'},
                                {name: 'q_ref', selector: 'q_ref'},
                        ],
                        'columns': [
				{'selector': 'id', 'lang_key': '#'},
                                {'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
                                {'selector': 'sz_members', 'lang_key': $j.getInfo("members",flt_lang)}
                        ],
                        'default_columns':['id', 'name', 'sz_members'],
                        'column_filters': {
                                'enabled': false
                        },
                        'callbacks': {
                                'load': content_loaded
                        }
                };

                var $container = $("#content");
                $container.qlist(qlist_settings);

        }

        return {configure: setup_qlist};

})(jQuery);
