var module_list = (function($) {
	'use strict';

	function content_loaded(qlist) {
                qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
        }

	function lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data,flt_lang);
	}

	function status_format_fn(td, col, row_data){
                var data = row_data[col.selector];
                return (data === "") ? data : $j.getInfo(data);
        }

	function bot_format_fn(td, col, row_data) {
		var data = row_data[col.selector];
		if(data == 'captcha-enforcement')
			return $j.getInfo('captcha_browser');
		else if(data == 'disabled')
			return $j.getInfo('disabled');
		else if(data == 'real-browser-enforcement')
			return $j.getInfo('real_browser_enforcement');

		return '';
	}

	function count_format_fn(td, col, row_data)
	{
		var key = 'sz_main-class';
		var s_count = parseInt(row_data[key])?1:0;
		var total = s_count;
		key = 'sz_access-limit-filter';
		total += parseInt(row_data[key]);
		key = 'sz_content-type';
		total += parseInt(row_data[key]);
		key = 'sz_http-header-filter';
		total += parseInt(row_data[key]);
		key = 'sz_http-transaction';
		total += parseInt(row_data[key]);
		key = 'sz_occurrence';
		total += parseInt(row_data[key]);
		key = 'sz_packet-interval';
		total += parseInt(row_data[key]);
		key = 'sz_parameter';
		total += parseInt(row_data[key]);
		key = 'sz_response-code';
		total += parseInt(row_data[key]);
		key = 'sz_source-ip-filter';
		total += parseInt(row_data[key]);
		key = 'sz_url-filter';
		total += parseInt(row_data[key]);
		key = 'sz_custom-signature';
		total += parseInt(row_data[key]);
		key = 'sz_signature';
		total += parseInt(row_data[key]);
		key = 'sz_sub-class';
		total += parseInt(row_data[key]);
		key = 'sz_user-filter';
		total += parseInt(row_data[key]);
		key = 'sz_geo-filter';
		total += parseInt(row_data[key]);
		key = 'sz_time-range-filter';
		total += parseInt(row_data[key]);
		return total;
	}

	function custom_rule_onclick_clone(qlist, elems)
	{
		var clone_url = '/waf/custom_access_rule/dlgcopy';
		var mkey = qlist_get_row_attr(elems, 'mkey');
		if(mkey){
			clone_url += '?mkey=' + encodeURIComponent(mkey);
			if(vdom) clone_url += '&vdom=' + encodeURIComponent(vdom);
			window.location.href = clone_url;
		}
	}

	function custom_rule_handle_selection_change(q)
	{
		qlist_handle_selection_change(q);

		var aElems = q.get_checked_rows();
		var mi_edit = $("#mi_edit_" + q.prefix);
		var mi_clone = $("#mi_clone_" + q.prefix);
		var mi_view = $("#mi_view_" + q.prefix);
		if(!is_rw_admin)
		{
			qmenu_enable_button(mi_view, true, q);
			return;
		}

		if(aElems.length == 1 && parseInt(qlist_get_row_attr(aElems[0], 'can_clone')) == 1)
			qmenu_enable_button(mi_clone, true, q);
		else
			qmenu_enable_button(mi_clone, false, q);

		if (aElems.length == 1 && parseInt(qlist_get_row_attr(aElems[0], 'default_flag')) == 1)
		{
			qmenu_enable_button(mi_view, true, q);
			qmenu_enable_button(mi_edit, false, q);
		}else{
			qmenu_enable_button(mi_view, false, q);
		}
	}

	function gen_qlist(datas){
		var menu_items = {};
		if(is_rw_admin){
			menu_items = {
				'mi_view': {
					'id': 'mi_view',
					'label': $.getInfo('view'),
					'class': 'tool_view',
					'handler': edit_click,
				},
				'mi_clone': {
					'id': 'mi_clone',
					'label': $.getInfo('clone'),
					'class': 'tool_clone',
					'handler': custom_rule_onclick_clone,
				}
			};
		}		
		var settings = {
			'prefix': 'custom_access_rule',
			'source': datas,
			'handle_selection_change': custom_rule_handle_selection_change,
			'menu_items': menu_items,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
				{name: 'can_clone', selector: 'can_clone'},
				{name: 'default_flag', selector: 'can_view'}
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name',flt_lang)},
				{'selector': 'action', 'lang_key': $j.getInfo('action',flt_lang)},
				{'selector': 'severity', 'lang_key': $j.getInfo('severity',flt_lang)},
				{'selector': 'trigger', 'lang_key': $j.getInfo('trigger',flt_lang)},
				{'selector': 'count', 'lang_key': $j.getInfo('list',flt_lang)},
				{'selector': 'block-period', 'lang_key': $j.getInfo('block_period',flt_lang)},
				{'selector': 'bot-recognition', 'lang_key': $j.getInfo('for_browser', flt_lang)},
		//		{'selector': 'real-browser-enforcement', 'lang_key': $j.getInfo('real_browser_enforcement',flt_lang)},
				{'selector': 'validation-timeout', 'lang_key': $j.getInfo('validation_timeout',flt_lang)},
				{'selector': 'max-attempt-times', 'lang_key': $j.getInfo('attempt_times', flt_lang)},
				{'selector': 'mobile-app-identification', 'lang_key': $.getInfo('for_mobile_app', flt_lang)},
				{'selector': 'bot-confirmation', 'lang_key': $.getInfo('bot_confirmation', flt_lang)}
			],
			'column_filters': {
				'enabled': false
			},
			'options': {
				'ref_column': false,
				'sorting': false,
			},
			'default_columns':['id', 'name', 'action', 'severity', 'trigger', 'count'],
			'format_fn': {
		//		'real-browser-enforcement': status_format_fn,
				'severity': lang_format_fn,
				'action': lang_format_fn,
				'count': count_format_fn,
				'bot-recognition': bot_format_fn,
				'mobile-app-identification': lang_format_fn,
				'bot-confirmation': lang_format_fn,
				'validation-timeout': function(td, col, row_data) {
					var data = row_data[col.selector];
					var bot_recognition = row_data['bot-recognition'];
					if (bot_recognition != 'disabled') { // bot recognition is not disabled
						return data;
					} else {
						return '-';
					}
				},
				'max-attempt-times': function(td, col, row_data) {
					var data = row_data[col.selector];
					var bot_recognition = row_data['bot-recognition'];
					if (bot_recognition == 'captcha-enforcement') { // bot recoginitin is captcha-enforcement
						return data;
					} else {
						return '-';
					}
				}
			},
			'callbacks': {
                                'load': content_loaded
                        }
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom, _: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/waf/custom_access_rule/list?vdom='+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
