var module_list = (function($) {
	'use strict';

	var action_lang = {
		'alert' : 'alert',
		'alert_deny' : 'alert_deny',
		'deny_no_log': 'deny_no_log',
		'block-period' : 'period_block',
		'using_local_action' : 'using_local_action'
	};

	function action_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		var lang = action_lang[data] ? action_lang[data] : '';
		return (lang === '') ? lang : $.getInfo(lang,flt_lang);
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function gen_qlist(datas){		
		var settings = {
			'prefix': 'device_tracking_policy_list',
			'source': datas,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name',flt_lang)},
				{'selector': 'action-for-high-level', 'lang_key': $j.getInfo('high_action',flt_lang)},
				{'selector': 'action-for-medium-level', 'lang_key': $j.getInfo('medium_action',flt_lang)},
				{'selector': 'action-for-low-level', 'lang_key': $j.getInfo('low_action',flt_lang)},
				{'selector': 'action-for-unindentified', 'lang_key': $j.getInfo('unindentified_action',flt_lang)},
				{'selector': 'reputation-exception-rule', 'lang_key': $j.getInfo('exception_policy',flt_lang)},
			],
			'column_filters': {
				'enabled': false
			},
			'default_columns':['id', 'name', 'action-for-high-level', 'action-for-medium-level',
				'action-for-low-level', 'action-for-unindentified', 'reputation-exception-rule'],
			'format_fn': {
				'action-for-high-level': action_format_fn,
				'action-for-medium-level': action_format_fn,
				'action-for-low-level': action_format_fn,
				'action-for-unindentified': action_format_fn
			},
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,_: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/waf/device_tracking_policy/list");
			}
		});
	}

	return {configure: configure};

})(jQuery);
