var module_list = (function($) {
	'use strict';

	function content_loaded(qlist) {
                qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
        }

	function status_format_fn(td, col, row_data){
                var data = row_data[col.selector];
                return (data === "") ? data : $j.getInfo(data);
        }

	function action_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		var key = '';
		if(data == 'block-period')
			key = 'block_period';
		else
			key = data;

		return $j.getInfo(key, flt_lang);
	}

	function severity_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		return (data === '') ? data : $j.getInfo(data, flt_lang);
	}

	function gen_qlist(datas){
		var settings = {
			'prefix': 'file_upload_policy',
			'source': datas,
//			'handle_selection_change': selection_changed,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name',flt_lang)},
				{'selector': 'action', 'lang_key': $j.getInfo('action',flt_lang)},
				{'selector': 'severity', 'lang_key': $j.getInfo('severity',flt_lang)},
				{'selector': 'trigger', 'lang_key': $j.getInfo('trigger',flt_lang)},
				{'selector': 'av-scan', 'lang_key': $j.getInfo('av_scan',flt_lang)},
				{'selector': 'fortisandbox-check', 'lang_key': $j.getInfo('fsa_check',flt_lang)},
				{'selector': 'trojan-detection', 'lang_key': $j.getInfo('trojan_detection', flt_lang)},
				{'selector': 'icap-server-check', 'lang_key': $j.getInfo('icap_check', flt_lang)}
			],
			'column_filters': {
				'enabled': false
			},
			'options': {
				'ref_column': false,
				'sorting': false,
			},
			'default_columns':['id', 'name', 'action', 'severity', 'trigger', 'av-scan', 'fortisandbox-check', 'icap-server-check'],
			'format_fn': {
				'severity': severity_format_fn,
				'action': action_format_fn,
				'av-scan': status_format_fn,
				'fortisandbox-check': status_format_fn,
				'trojan-detection': status_format_fn,
				'icap-server-check': status_format_fn
			},
			'callbacks': {
                                'load': content_loaded
                        }
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom,_: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/waf/file_upload_policy/list?vdom='+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
