var module_list = (function($) {
	'use strict';

	function content_loaded(qlist) {
                qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
        }

	function type_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		var key = '';
		if(data == 'plain')
			key = 'simple';
		else if(data == 'regular')
			key = 'regex';
		return $j.getInfo(key, flt_lang);
	}

	function file_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		return escapeHTML(data);
	}

	function action_type_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		var key = '';
		if(data == 'Allow')
			key = 'allow_type';
		else if(data == 'Block')
			key = 'block_type';
		return $j.getInfo(key, flt_lang);
	}

	function gen_qlist(datas){
		var settings = {
			'prefix': 'file_upload_rule',
			'source': datas,
//			'handle_selection_change': selection_changed,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name',flt_lang)},
				{'selector': 'host', 'lang_key': $j.getInfo('host',flt_lang)},
				{'selector': 'request-type', 'lang_key': $j.getInfo('req_url_type',flt_lang)},
				{'selector': 'request-file', 'lang_key': $j.getInfo('req_url',flt_lang)},
				{'selector': 'file-size-limit', 'lang_key': $j.getInfo('file_upload_limit',flt_lang)},
				{'selector': 'type', 'lang_key': $j.getInfo('type', flt_lang)},
				{'selector': 'sz_file-types', 'lang_key': $j.getInfo('count')},
			],
			'column_filters': {
				'enabled': true,
				'exempts': ['id', 'name', 'request-type', 'request-file', 'file-size-limit', 'sz_file-types', 'type']
			},
			'options': {
				'ref_column': false,
				'sorting': false,
			},
			'default_columns':['id', 'name', 'host', 'request-type', 'request-file', 'file-size-limit', 'type', 'sz_file-types'],
			'format_fn': {
				'request-type': type_format_fn,
				'request-file': file_format_fn,
				'type': action_type_format_fn
			},
			'callbacks': {
                                'load': content_loaded
                        }
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom,_: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/waf/file_upload_rule/list?vdom='+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
