var module_list = (function($) {
        'use strict';

        var source;
        var config_type_lang = {
		'full-config': 'full_config',
		'cli-config': 'cli_config',
		'waf-config': 'waf_config'
	};
	var schedule_type_lang = {
		'now': 'now',
		'days': 'daily'
	};

        function lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data,fgt_lang);
	}

	function protocol_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === 'ftp') ? 'FTP' : 'SFTP';
	}

	function html_encode_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === '') ? data : escapeHTML(data);
	}

	function option_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		var options_lang = null;
		if(col.selector == 'config-type')
			options_lang = config_type_lang;
		else if(col.selector == 'schedule_type')
			options_lang = schedule_type_lang;
		else
			return '';

		var lang = options_lang[data] ? options_lang[data] : '';
		return (lang === '') ? lang : $.getInfo(lang,flt_lang);
	}

	function content_loaded(qlist) {
                qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
        }

	function gen_qlist(datas){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		source = datas;

		var qlist_settings = {
                        'prefix': 'ftp_backup',
                        'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
                        'row_attr': [
                                {name: 'mkey', selector: 'name'},
                                {name: 'q_ref', selector: 'q_ref'},
                        ],
                        'columns': [
                                {'selector': 'id', 'lang_key': '#'},
                                {'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
                                {'selector': 'protocol-type', 'lang_key': $j.getInfo("backup_protocol",flt_lang)},
                                {'selector': 'ftp-server', 'lang_key': $j.getInfo("ftp_server",flt_lang)},
                                {'selector': 'config-type', 'lang_key': $j.getInfo('backup_type', flt_lang)},
                                {'selector': 'schedule_type', 'lang_key': $j.getInfo("schedule_type",flt_lang)},
				{'selector': 'ftp-dir', 'lang_key': $j.getInfo("ftp_dir",flt_lang)},
				{'selector': 'ftp-auth', 'lang_key': $j.getInfo("ftp_auth",flt_lang)},
				{'selector': 'encryption', 'lang_key': $j.getInfo("encrypt",flt_lang)}
                        ],
                        'default_columns':['id', 'name', 'protocol-type', 'ftp-server', 'config-type', 'schedule_type'],
                        'column_filters': {
                                'enabled': false,
                        },
        //                'handle_selection_change': selection_changed,
                        'callbacks': {
                                'load': content_loaded
                        },
                        'format_fn': {
				'protocol-type': protocol_format_fn,
				'ftp-server': html_encode_format_fn,
				'config-type': option_format_fn,
				'schedule_type': option_format_fn,
				'ftp-dir': html_encode_format_fn,
				'ftp-auth': lang_format_fn,
				'encryption': lang_format_fn,
			}
                };

                var $container = $("#content");
                $container.qlist(qlist_settings);

        }

        function configure () {
		$.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,_: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/system/schedule/list');
			}
		});
	}

	return {configure: configure};

})(jQuery);
