var module_list = (function($) {
        'use strict';

        function ip_intelligence_format_fn(td, col, row_data){
                var data = row_data[col.selector];
                return (data === '') ? data: $j.getInfo(data, flt_lang);
        }       

        function setup_qlist()
        {
                $.ajax({
                        'url': '/cli-direct-action?table_gid='+g_cmdb_table_id,
                        'dataType': 'json',
                        'success': function(response)
                        {
                                if(response.status == 1)
                                {
                                        var source = response.datas;
                                        gen_qlist(source);
                                }
                                else if(response.status == 0)
                                        error_handler(response.msg_id, "/waf/ftp_profile_inline/list");
                        },
                        'cache': false
                });
        }

        function content_loaded(qlist) {
                qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
        }

	function gen_qlist(source){
		var qlist_settings = {
                        'prefix': 'ftp_profile_inline',
                        'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
                        'row_attr': [
                                {name: 'mkey', selector: 'name'},
                                {name: 'q_ref', selector: 'q_ref'},
                        ],
                        'columns': [
                                {'selector': 'id', 'lang_key': '#'},
                                {'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
				{'selector': 'ftp-restriction-command-type', 'lang_key': $j.getInfo('command_res', flt_lang)},
				{'selector': 'ftp-file-check', 'lang_key': $j.getInfo('file_check', flt_lang)},
				{'selector': 'ftp-ip-check', 'lang_key': $j.getInfo('ip_check', flt_lang)},
				{'selector': 'ftp-geo-ip', 'lang_key': $j.getInfo('geo_ip', flt_lang)},
				{'selector': 'ftp-ip-intelligence', 'lang_key': $j.getInfo('ip_intelligence', flt_lang)}
                        ],
                        'default_columns':['id', 'name', 'ftp-restriction-command-type', 'ftp-file-check', 'ftp-ip-check', 'ftp-geo-ip', 'ftp-ip-intelligence'],
                        'column_filters': {
                                'enabled': false,
                        },
                        'callbacks': {
                                'load': content_loaded
                        },
                        'format_fn': {
                                'ftp-ip-intelligence': ip_intelligence_format_fn,
                        }
                };

                var $container = $("#content");
                $container.qlist(qlist_settings);

        }

        return {configure: setup_qlist};

})(jQuery);
