var module_list = (function($) {
    'use strict';

    var source;
    var page_size = 100;
    var json_path_ha = '/ha_redir';
    var json_path = '/manager_redir';
    var path_uri = "api/v1.0/LogReport/LogAccess/LogAccessAttack"

    var formatter = FOSGUI.LogFormatter.getFormatter();
    function new_content_cb(content) {
        DetailsWindow.initialize({
            containerSelector : "body",
            mainPanelSelector : "#main_window",
            detailsPanelSelector : "#logview-details",
            contentBodySelector: '#contentHead table.qlist > tbody:first',
            detailsLocation : "east",
            isShowThreatDetails:false,
            formatCallbacks : formatter,
            rowData : content.source,
            langOverride : {}
        });
    }
/*
    function authtype_format_fn(td, col, row_data){
        var authtype = row_data[col.selector];
        var html = $j.getInfo(authtype, flt_lang);

        return html;
    }

    function time_format_fn(td, col, row_data){
        var value = row_data[col.selector];
        var dt = fweb.util.localDateSeconds(value);
        // TODO: see why the FortiGate is using local time instead of UTC
        var result = $j.format_date_diff(dt);

        return '<span title="' + dt.toLocaleString() + '">' + result + '</span>';
    }
    function pri_format_fn(td, col, row_data){
        var value = row_data[col.selector];
        var sev_class = 'log_severity_' + value;
        var sev = '';
        sev += '<span class="log_severity_level ';
        sev += sev_class + '" title="' + value + '"></span>';
        return sev;        
    }
    function fpm_format_fn(td, col, row_data){
        var val = row_data[col.selector] ? row_data[col.selector] : '';
        var html = '';
        if(val == 'yes')
            html = "<span style='vertical-align: bottom;' ><img src='/images/status_enabled.png'>&nbsp;Enabled</span>";
        else if(val == 'no')
            html = "<span style='vertical-align: bottom;'><img src='/images/status_disabled.png' />&nbsp;Disabled</span>";
        else
            html = "N/A";

            return html;        

    }
    function type_format_fn(td, col, row_data){
        var val = row_data[col.selector] ? row_data[col.selector] : '';
        var html = '';
        if(val == 'LOG_TYPE_SCORE_SUM')
            html = "<span style='vertical-align: bottom;'><img src='/images/status_sum.png' style='width:16px;height:16px;' title='"+$j.getInfo('yes')+"'>"+$j.getInfo('yes')+"</span>";

            return html;
    }
    function code_format_fn(td, col, row_data){
        var html = '';
        if(row_data[col.selector] != '0')    html = row_data[col.selector];
        return html;        
    }

    function src_format_fn(td, col, row_data){
        var ip = row_data[col.selector] ? row_data[col.selector]:'';
        var flag = row_data['country_flag'] ? row_data['country_flag']:'';
        var html = '<span class="country_flag country_'+flag+'"></span>&nbsp;<span>'+ip+'<span>';
        return html;
    }
*/
	function refresh()
	{
		location.reload();
	}
	function return_back()
	{
        if(dev_id != 0)
		  location.href = "/system/ha/topology";
        else
          location.href = "/system/manager_cluster/topology";

	}

	function gen_menu()
	{
		var menu = {};
		menu["mi_refresh"] = {
			'ctxt' : false,
			"class" : "tool_retrieve",
			"label" : $.getInfo("refresh"),
			"handler" : refresh
		}
		menu["mi_return"] = {
			'ctxt' : false,
			"class" : "tool_export",
			"label" : $.getInfo("return"),
			"handler" : return_back
		}
		return menu;
	}
    function showLoading() {
        'use strict';
        $j('#loading').css('display', '');
        $j('#contentHead').children().hide();
    };
    function hideLoading() {
        'use strict';
        $j('#loading').hide();
        $j('#contentHead').children().show();
    };
    function gen_qlist(datas){

        var source = datas.payload;
        var completed = page_size;
        var total_lines = datas.total;
        var filter_offset = datas.filter_offset;
        var content = {'source':source,'completed':completed,'total_lines':total_lines,'filter_offset':filter_offset};

        function search_completed() {
            return content.completed >= page_size;
        }    

        var qlist_settings = {
            'prefix': 'ha_log',
            'source': source,
            'cr_new_url': null,
            'cr_edit_url': null,
            'row_attr': [
                {name: '_id', selector: '#'},
            ],
            'columns': log_column,
            'default_columns':default_columns,
            'column_filters': {
                'enabled': false,
                'exempts': ['_id']
            },
            'menu_items': gen_menu(),
            'options':{
    		    'fixed_footer':false,
                'ref_column': false,
                'sorting': false,
    		    'hide_default_buttons': true
            },
            paging: {
                enabled: true,
                server_side: true,
                total_lines: content.total_lines,
                completed: search_completed,
                fetch: function(page_num, cb) {
                    var path = dev_id>0?json_path_ha:json_path;
                    path_uri = setQueryValue(path_uri, 'size', 100);
                    path_uri = setQueryValue(path_uri, 'offset', (page_num-1)*100);
                    path_uri = setQueryValue(path_uri, 'filter_offset', filter_offset);                    
                    path_uri = setQueryValue(path_uri, 'log_type', log_type);
                    path_uri = setQueryValue(path_uri, 'log', logfile);
                    path_uri = setQueryValue(path_uri, 'filter', "[]");
                    
                    path_uri = setQueryValue(path_uri, '_', new Date().getTime());
                    if (page_num !== datas.page_num) {
                        page_num = page_num;
                        source.length = 0;
                    } else {
                        path_uri = setQueryValue(path_uri, 'fetched', datas.payload.length);
                    }
                    showLoading();

                    path = setQueryValue(path, 'uri', path_uri);
                    path = setQueryValue(path, 'ip', ip);
                    path = setQueryValue(path, 'dev_id', dev_id);

                    $j.getJSON(path, function(data) {
                        hideLoading();
                        content.completed = page_size;
                        content.total_lines = data.total;  
                        content.source = data.payload;
                        content.filter_offset = data.filter_offset;
                        //The call order is critical, because cb updates DOM
                        cb(content);
                        $j.merge(content.source, data.payload);
                                              
                        if (!$j('tr.selected', '#datas').length) {
                            new_content_cb(content);
                        }
                        $j('#datas').qlist('refresh');
                        content.filter_offset = data.filter_offset;
                    });
                    // }).fail(function() {
                    //     alert($j.getInfo('error_ha_log', flt_lang));
                    //     document.location.href = "/system/ha/topology";
                    // });
                }
            },
            'format_fn': {
                // 'rel_time': time_format_fn,
                // 'pri': pri_format_fn,
                // 'false_positive_mitigation': fpm_format_fn,
                // 'log_type': type_format_fn,
                // 'http_retcode': code_format_fn,
                // 'src':src_format_fn
                
                // set default to escape all outputs prevent XSS Injection
                '*': function(td, col, entry) {
                    return escapeHTML(entry[col.selector]);
                }
            },
            row_gen: function(rowIndex, row_data)
            {
                if(log_type == 1)
                {
                    var pri = row_data['pri'] ? row_data['pri'] : 'information';
                    var c = 'log_' + pri;
                    this.addClass(c);
                }
                else if(log_type == 3)
                {
                    var action = row_data['action'].toLowerCase();
                    var monitor = row_data['monitor_status'] ? row_data['monitor_status'] : 'Disabled';
                    var c = '';
                    if(monitor == 'Enabled')
                        c = 'odd';
                    else
                    {
                        if(action == 'alert')
                            c = 'odd';
                        else
                            c = 'log_deny';
                    }

                    this.addClass(c);
                }
            }
        };

        // delegate the format function to the appropriate formatter function
        for (var x in formatter) {
            qlist_settings.format_fn[x] = FOSGUI.LogFormatter.format_fn_to;
        }

        var $container = $("#contentHead");
        $container.qlist(qlist_settings);

        $j("tr", "#contentHead").live("click", DetailsWindow.click);
        $j(document).keydown(DetailsWindow.keypress);

        $j('#ha_log_qlist_ftrbar').addClass('qlist_fixed_ftrbar');
        new_content_cb(content);
    }

    function configure () {
        var path = dev_id>0?json_path_ha:json_path;
        path_uri = setQueryValue(path_uri, 'size', 100);
        path_uri = setQueryValue(path_uri, 'offset', 0);
        path_uri = setQueryValue(path_uri, 'filter_offset', filter_offset);
        path_uri = setQueryValue(path_uri, 'log_type', log_type);
        path_uri = setQueryValue(path_uri, 'log', logfile);
        path_uri = setQueryValue(path_uri, 'filter', "[]");
        
        path_uri = setQueryValue(path_uri, '_', new Date().getTime());
        path = setQueryValue(path, 'uri', path_uri);
        path = setQueryValue(path, 'ip', ip);
        path = setQueryValue(path, 'dev_id', dev_id);
        $j.getJSON(path, function(results) {
            if(results) {
                gen_qlist(results);
            } else {
                error_handler(results.msg_id, "/ha/log");
            }
        });
        // }).fail(function() {
        //     alert($j.getInfo('error_ha_log', flt_lang));
        //     document.location.href = "/system/ha/topology";
        // });
    }

    return {configure: configure};

})(jQuery);
