var module_list = (function($) {
	'use strict';

	function setup_qlist()
	{
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id, _: new Date().getTime()},function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/system/ha_static_route/list');
			}
		});
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
		qlist.cr_del_url = '/delete?type=0';
	}

	function  route_delete_click(qlist, elems)
	{
		var aElems = qlist.get_checked_rows();
		var del_url = '/delete?id=' + g_cmdb_table_id+'&session_id='+session_id+'&type=0';
		aElems.each(function() {
			del_url += '&mkey=' + encodeURIComponent(qlist_get_row_attr(this, 'mkey'));
		});
		$j.submitPOST(del_url);
	}

	function gen_qlist(source){

		var qlist_settings = {
			'prefix': 'ha_static_route',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'id'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'dst', 'lang_key': $j.getInfo("ip",flt_lang)+'/'+$.getInfo('mask',flt_lang)},
				{'selector': 'gateway', 'lang_key': $j.getInfo("gateway",flt_lang)},
				{'selector': 'device', 'lang_key': $j.getInfo('device', flt_lang)},
			],
			'default_columns':['id', 'dst', 'gateway', 'device'],
			'column_filters': {
				'enabled': true,
				'exempts': ['id']
			},
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);
	}

	return {configure: setup_qlist};

})(jQuery);
