var module_list = (function($) {
	'use strict';

	function content_loaded(qlist) {
                qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
        }

	function hpc_exception_onclick_clone(qlist, elems)
        {
                var clone_url = '/waf/http_constraints_expt/dlgcopy';
                var mkey = qlist_get_row_attr(elems, 'mkey');
                if(mkey){
                        clone_url += '?mkey=' + encodeURIComponent(mkey);
                        if(vdom) clone_url += '&vdom=' + encodeURIComponent(vdom);
                        window.location.href = clone_url;
                }
        }

	function hpc_exception_handle_selection_change(q)
        {
                qlist_handle_selection_change(q);

                var aElems = q.get_checked_rows();
                var mi_edit = $j("#mi_edit_" + q.prefix);
                var mi_clone = $j("#mi_clone_" + q.prefix);
                var mi_view = $j("#mi_view_" + q.prefix);
                if(!is_rw_admin)
                {
                        qmenu_enable_button(mi_view, true, q);
                        return;
                }

                if(aElems.length == 1 && parseInt(qlist_get_row_attr(aElems[0], 'can_clone')) == 1)
                        qmenu_enable_button(mi_clone, true, q);
                else
                        qmenu_enable_button(mi_clone, false, q);

                if (aElems.length == 1 && parseInt(qlist_get_row_attr(aElems[0], 'default_flag')) == 1)
                {
                        qmenu_enable_button(mi_view, true, q);
                        qmenu_enable_button(mi_edit, false, q);
                }else{
                        qmenu_enable_button(mi_view, false, q);
                }
        }

	function gen_qlist(datas){
		var menu_items = {};
                if(is_rw_admin){
                        menu_items = {
                                'mi_view': {
                                        'id': 'mi_view',
                                        'label': $.getInfo('view'),
                                        'class': 'tool_view',
                                        'handler': edit_click,
                                },
                                'mi_clone': {
                                        'id': 'mi_clone',
                                        'label': $.getInfo('clone'),
                                        'class': 'tool_clone',
                                        'handler': hpc_exception_onclick_clone,
                                }
                        };
                }

		var settings = {
			'prefix': 'hpc_exception',
			'source': datas,
			'handle_selection_change': hpc_exception_handle_selection_change,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'menu_items': menu_items,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
				{name: 'default_flag', selector: 'can_view'},
				{name: 'can_clone', selector: 'can_clone'}
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name',flt_lang)},
				{'selector': 'sz_http_constraints-exception-list', 'lang_key': $j.getInfo('count',flt_lang)},
			],
			'column_filters': {
				'enabled': false
			},
			'options': {
				'ref_column': false,
				'sorting': false,
			},
			'default_columns':['id', 'name', 'sz_http_constraints-exception-list'],
			'callbacks': {
                                'load': content_loaded
                        }
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom,_: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/waf/http_constraints_expt/list?vdom='+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
