var module_list = (function($) {
	'use strict';

	function content_loaded(qlist) {
                qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
        }

	function status_format_fn(td, col, row_data){
                var data = row_data[col.selector];
                return (data === "") ? data : $j.getInfo(data);
        }

	function hpc_onclick_clone(qlist, elems)
        {
                var clone_url = '/waf/http_pro_par_res/dlgcopy';
                var mkey = qlist_get_row_attr(elems, 'mkey');
                if(mkey){
                        clone_url += '?mkey=' + encodeURIComponent(mkey);
                        if(vdom) clone_url += '&vdom=' + encodeURIComponent(vdom);
                        window.location.href = clone_url;
                }
        }

	function hpc_handle_selection_change(q)
        {
                qlist_handle_selection_change(q);

                var aElems = q.get_checked_rows();
                var mi_edit = $("#mi_edit_" + q.prefix);
                var mi_clone = $("#mi_clone_" + q.prefix);
                var mi_view = $("#mi_view_" + q.prefix);
                if(!is_rw_admin)
                {
                        qmenu_enable_button(mi_view, true, q);
                        return;
                }

                if(aElems.length == 1 && parseInt(qlist_get_row_attr(aElems[0], 'can_clone')) == 1)
                        qmenu_enable_button(mi_clone, true, q);
                else
                        qmenu_enable_button(mi_clone, false, q);

                if (aElems.length == 1 && parseInt(qlist_get_row_attr(aElems[0], 'default_flag')) == 1)
                {
                        qmenu_enable_button(mi_view, true, q);
                        qmenu_enable_button(mi_edit, false, q);
                }else{
                        qmenu_enable_button(mi_view, false, q);
                }
        }

	function gen_qlist(datas){
		var menu_items = {};
                if(is_rw_admin){
                        menu_items = {
                                'mi_view': {
                                        'id': 'mi_view',
                                        'label': $.getInfo('view'),
                                        'class': 'tool_view',
                                        'handler': edit_click,
                                },
                                'mi_clone': {
                                        'id': 'mi_clone',
                                        'label': $.getInfo('clone'),
                                        'class': 'tool_clone',
                                        'handler': hpc_onclick_clone,
                                }
                        };
                }

		var settings = {
			'prefix': 'hpc_res',
			'source': datas,
			'handle_selection_change': hpc_handle_selection_change,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'menu_items': menu_items,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
				{name: 'default_flag', selector: 'can_view'},
				{name: 'can_clone', selector: 'can_clone'}
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name',flt_lang)},
				{'selector': 'Illegal-content-length-check', 'lang_key': $j.getInfo('illegal_content_length',flt_lang)},
				{'selector': 'Illegal-content-type-check', 'lang_key': $j.getInfo('illegal_content_type',flt_lang)},
				{'selector': 'Illegal-header-name-check', 'lang_key': $j.getInfo('illegal_head_name',flt_lang)},
				{'selector': 'Illegal-header-value-check', 'lang_key': $j.getInfo('illegal_head_value',flt_lang)},
				{'selector': 'Illegal-host-name-check', 'lang_key': $j.getInfo('host_name_check',flt_lang)},
				{'selector': 'Illegal-http-request-method-check', 'lang_key': $j.getInfo('illegal_http_request_method',flt_lang)},
				{'selector': 'Illegal-http-version-check', 'lang_key': $j.getInfo('http_version_check',flt_lang)},
				{'selector': 'Illegal-response-code-check', 'lang_key': $j.getInfo('illegal_res_code',flt_lang)},
				{'selector': 'Post-request-ctype-check', 'lang_key': $j.getInfo('post_req_ctype',flt_lang)},
				{'selector': 'block-malformed-request-check', 'lang_key': $j.getInfo('block_malformed_request',flt_lang)},
				{'selector': 'max-cookie-in-request', 'lang_key': $j.getInfo('cookie_in_req',flt_lang)},
				{'selector': 'max-header-line-request', 'lang_key': $j.getInfo('header_line_request',flt_lang)},
				{'selector': 'max-http-body-length', 'lang_key': $j.getInfo('body_len',flt_lang)},
				{'selector': 'max-http-body-parameter-length', 'lang_key': $j.getInfo('max_bparam_len',flt_lang)},
				{'selector': 'max-http-content-length', 'lang_key': $j.getInfo('content_len',flt_lang)},
				{'selector': 'max-http-header-length', 'lang_key': $j.getInfo('head_len',flt_lang)},
				{'selector': 'max-http-header-name-length', 'lang_key': $j.getInfo('head_name_len',flt_lang)},
				{'selector': 'max-http-header-value-length', 'lang_key': $j.getInfo('head_value_len',flt_lang)},
				{'selector': 'max-http-request-length', 'lang_key': $j.getInfo('http_request_length',flt_lang)},
				{'selector': 'max-url-parameter', 'lang_key': $j.getInfo('url_parameter',flt_lang)},
				{'selector': 'max-url-parameter-length', 'lang_key': $j.getInfo('url_parameter_length',flt_lang)},
				{'selector': 'number-of-ranges-in-range-header', 'lang_key': $j.getInfo('number_of_range',flt_lang)},
				{'selector': 'parameter-name-check', 'lang_key': $j.getInfo('param_name',flt_lang)},
				{'selector': 'parameter-value-check', 'lang_key': $j.getInfo('param_value',flt_lang)},
				{'selector': 'web-socket-protocol-check', 'lang_key': $j.getInfo('web_socket',flt_lang)},
				{'selector': 'Illegal-magic-check', 'lang_key': $j.getInfo('connection_preface',flt_lang)},
				{'selector': 'Illegal-frame-type-check', 'lang_key': $j.getInfo('frame_type',flt_lang)},
				{'selector': 'Illegal-frame-flag-check', 'lang_key': $j.getInfo('frame_flags',flt_lang)},
				{'selector': 'max-setting-initial-window-size', 'lang_key': $j.getInfo('window_size',flt_lang)},
				{'selector': 'max-setting-header-table-size', 'lang_key': $j.getInfo('header_table_size',flt_lang)},
				{'selector': 'max-setting-header-list-size', 'lang_key': $j.getInfo('header_list_size',flt_lang)},
				{'selector': 'max-setting-frame-size', 'lang_key': $j.getInfo('frame_size',flt_lang)},
				{'selector': 'max-setting-current-streams-num', 'lang_key': $j.getInfo('concurrent_streams',flt_lang)},
				{'selector': 'max-url-param-name-len-check', 'lang_key': $j.getInfo('max_param_name', flt_lang)},
				{'selector': 'max-url-param-value-len-check', 'lang_key': $j.getInfo('max_param_value', flt_lang)},
				{'selector': 'url-param-name-check', 'lang_key': $j.getInfo('urlparam_name_check', flt_lang)},
				{'selector': 'url-param-value-check', 'lang_key': $j.getInfo('urlparam_value_check', flt_lang)},
				{'selector': 'null-byte-in-url-check', 'lang_key': $j.getInfo('null_url_check', flt_lang)},
				{'selector': 'illegal-byte-in-url-check', 'lang_key': $j.getInfo('illegal_url_check', flt_lang)},
				{'selector': 'malformed-url-check', 'lang_key': $j.getInfo('malformed_url_check', flt_lang)},
				{'selector': 'rpc-protocol-check', 'lang_key': $j.getInfo('rpc_protocol', flt_lang)},
				{'selector': 'redundant-header-check', 'lang_key': $j.getInfo('redundant_header', flt_lang)},
				{'selector': 'chunk-size-check', 'lang_key': $j.getInfo('illegal_chunk', flt_lang)},
				{'selector': 'duplicate-paramname-check', 'lang_key': $j.getInfo('duplicate_param_name', flt_lang)}
			],
			'column_filters': {
				'enabled': false
			},
			'options': {
				'ref_column': false,
				'sorting': false,
			},
			'format_fn': {
				'Illegal-content-type-check': status_format_fn,
				'Illegal-content-length-check': status_format_fn,
				'Illegal-header-name-check': status_format_fn,
				'Illegal-header-value-check': status_format_fn,
				'Illegal-host-name-check': status_format_fn,
				'Illegal-http-request-method-check': status_format_fn,
				'Illegal-http-version-check': status_format_fn,
				'Illegal-response-code-check': status_format_fn,
				'Post-request-ctype-check': status_format_fn,
				'block-malformed-request-check': status_format_fn,
				'web-socket-protocol-check': status_format_fn,
				'parameter-name-check': status_format_fn,
				'parameter-value-check': status_format_fn,
				'Illegal-magic-check': status_format_fn,
				'Illegal-frame-type-check': status_format_fn,
				'Illegal-frame-flag-check': status_format_fn,
				'max-setting-current-streams-num-check': status_format_fn,
				'max-url-param-name-len-check': status_format_fn, 
				'max-url-param-value-len-check': status_format_fn,
				'url-param-name-check': status_format_fn,
				'url-param-value-check': status_format_fn,
				'null-byte-in-url-check': status_format_fn,
				'illegal-byte-in-url-check': status_format_fn,
				'malformed-url-check': status_format_fn,
				'redundant-header-check': status_format_fn,
				'chunk-size-check': status_format_fn,
				'duplicate-paramname-check': status_format_fn,
				'rpc-protocol-check': status_format_fn
			},
			'default_columns':['id', 'name', 'max-http-header-length', 'max-http-content-length', 'max-http-body-length'],
			'callbacks': {
                                'load': content_loaded
                        }
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom,_:new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/waf/http_pro_par_res/list?vdom='+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
