var module_list = (function($) {
	'use strict';

	var source;

	function configure()
	{
		$j.getJSON('/cli-direct-action', {
			table_gid: g_cmdb_table_id, 
			vdom: vdom, 
			_: new Date().getTime()
		}, function(results) {
			if (results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/prot/http_content_routing_policy/list");
			}
		});
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function gen_qlist(datas) {
		var qlist_settings = {
			'prefix': 'http_content_routing',
			'source': datas,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
				{'selector': 'server-pool', 'lang_key': $j.getInfo("server_pool",flt_lang)},
				{'selector': 'sz_content-routing-match-list', 'lang_key': $j.getInfo("page",flt_lang)}
			],
			'default_columns': ['id', 'name', 'server-pool', 'sz_content-routing-match-list'],
			'column_filters': {
				'enabled': false
			},
			//'handle_selection_change': selection_changed,
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);

	}

	return {configure: configure};

})(jQuery);
