var module_list = (function($) {
	'use strict';
	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}
	function lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data, flt_lang);
	}
	function gen_qlist(datas) {
		
		var settings = {
			'prefix': 'mitb_rule',
			'source': datas,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name', flt_lang)},
				{'selector': 'host-status', 'lang_key': $j.getInfo('host_status', flt_lang)},
				{'selector': 'host', 'lang_key': $j.getInfo('host', flt_lang)},
				{'selector': 'request-type', 'lang_key': $j.getInfo('request_type', flt_lang)},
				{'selector': 'request-url', 'lang_key': $j.getInfo('request_url', flt_lang)},
				{'selector': 'post-url', 'lang_key': $j.getInfo('post_url', flt_lang)},
				{'selector': 'action', 'lang_key': $j.getInfo('action', flt_lang)},
				{'selector': 'severity', 'lang_key': $j.getInfo('severity', flt_lang)},
				{'selector': 'trigger', 'lang_key': $j.getInfo('trigger', flt_lang)}
			],
			'column_filters': {
				'enabled': false,
			},
			'paging': {
				'enabled': false,
			},
			'options': {
				'ref_column': false,
				'sorting': false
			},
            'callbacks': {
                'load': content_loaded
            },
			'default_columns':['id', 'name', 'host-status', 'host', 'request-type', 'request-url', 'post-url', 'action', 'severity', 'trigger'],
			'search': { 'enabled': false },
			'format_fn': {
				'action': lang_format_fn,
				'severity': lang_format_fn,
				'request-type': lang_format_fn,
				'host-status': lang_format_fn
			},
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom,_: new Date().getTime()},function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/waf/mitb_rule/list?vdom='+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
