var module_list = (function($) {
	'use strict';

	var source;

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function comment_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		return escapeHTML(data);
	}

	function gen_qlist(datas){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		source = datas;

		var qlist_settings = {
			'prefix': 'multi_cert',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $.getInfo("name",flt_lang)},
				{'selector': 'rsa-cert', 'lang_key': $.getInfo("rsa_certificate",flt_lang)},
				{'selector': 'dsa-cert', 'lang_key': $.getInfo("dsa_certificate",flt_lang)},
				{'selector': 'ecc-cert', 'lang_key': $.getInfo("ec_certificate",flt_lang)},
				// {'selector': 'ocsp_url', 'lang_key': $.getInfo("ocsp_url",flt_lang)},
				{'selector': 'comment', 'lang_key': $.getInfo("comment",flt_lang)}
			],
			'default_columns':['id', 'name', 'rsa-cert', 'dsa-cert', 'ecc-cert', 'comment'],
			'column_filters': {
				'enabled': false
			},
			'callbacks': {
				'load': content_loaded
			},
			'format_fn': {
				'comment': comment_format_fn
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);

	}

	function configure()
	{
		$.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id, _: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/sys/cert_multi/list");
			}
		});
	}

	return {configure: configure};

})(jQuery);
