/********************
 * policy status list
 * by shuyusun
 * ******************/

var module_list = (function($){
	'use strict'
	var source;
	
	function setup_qlist()
	{
		$.ajax({
			'url': '/system/status/policy_status/json',
			'dataType': 'json',
			'success': function(response)
			{
				if(response.status == 1)
				{
					source = response.results;
					gen_qlist();
					system_policy_status_onload();	
				}
				else if(response.status == 0)
					error_handler(response.msg_id, "/system/status/policy_status");
			},
			'cache': false

		});
	}
	
	function content_loaded(qlist) 
	{
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}
	
	function system_policy_status_onload()
	{
		$j("tbody tr", "#policy_status-qlist").live("click", DetailsWindow.click);
		$j(document).keydown(DetailsWindow.keypress);
		
		var column_lang = {};

		DetailsWindow.initialize({
			"containerSelector" : "body",
			"mainPanelSelector" : "#main_window",
			"detailsPanelSelector" : "#policy_details",
			"detailsLocation" : "south",
			"initialHidden" : false,
			"formatCallbacks" : {},
			"rowData" : policy_status,
			"langOverride" : column_lang
		});

	}
	function server_side_reload()
	{
		setup_qlist();
	}
	
	function refresh()
	{
		location.reload();
	}

	function return_db()
	{   
		var q = qlist_obj;
		/*
		setup_mask_div();
		display_mask_div('0.3');
		nb_refresh_menu('status');
		*/
		top.mainnav.document.getElementById('cur_menu').value = 'status';
	}

	function gen_menu()
	{
		var menu = {};
		menu["mi_refresh"] = {
			'ctxt' : false,
			"class" : "tool_retrieve",
			"label" : $.getInfo("refresh"),
			"handler" : refresh
		}
		menu["mi_return"] = {
			'ctxt' : false,
			"class" : "tool_export",
			"label" : $.getInfo("return_str"),
			"handler" : return_db
		}

		return menu;
	}

	function status_format_fn($td, col, row_data)
	{
		var sts = row_data.status;
		var html = '';

		if(sts == true)
		{
			html = '<div><span><f-icon class="fa-link" style="color: #33cc00"></f-icon></span></div>';
			//html = '<div><span><img width="15" height="15" src="/images/st_ok.gif"></span></div>';
		}
		else if(sts == false)
		{
			html = '<div><span><f-icon class="fa-chain-broken" style="color: #ff6600"></f-icon></span></div>';
			//html = '<div><span><img src="/images/st_na.gif" width=15 height=15></span></div>';
		}

		return html;
	}
	function hc_status_format_fn($td, col, row_data)
	{
		var sts = row_data.hc_status;
		var html = '';

		if(sts == 1)
		{
			html = '<span><f-icon class="fa-link" style="color: #33cc00"></f-icon></span>';
		}
		else if(sts == 2)
		{
			html = '<span><f-icon class="fa-chain-broken" style="color: #ff6600"></f-icon></span>';
		}else{
			html = '<span><f-icon class="ftnt-help-o" style="color: #999"></f-icon></span>';                
		}

		return html;
	}

	function vserver_format_fn($td, col, row_data)
	{
		var vserver = row_data.vserver;

		return vserver;
	}
	function gen_qlist(){
        if (!window.fgt_lang || !fgt_lang["global"])
            $j.addLang();

        var qlist_settings = {
            'prefix': 'policy_status',
            'source': source,
            'row_attr': [
                    {name: 'mkey', selector: 'id'},
                    {name: 'can_edit', selector: 'can_edit'},
                    {name: 'type', selector: 'type'},
                    {name: 'ref', selector: 'q_ref'},
                    {name: 'status', selector: 'status'}
                ],
            'columns': [
		    	{'selector': 'name', 'lang_key': "name"},
		    	{'selector': 'status', 'lang_key': "status"},
		    //	{'selector': 'hc_status', 'lang_key': "hc_status"},
				{'selector': 'vserver', 'lang_key': "vserver"},
				{'selector': 'protocol', 'lang_key': 'protocol'},
				{'selector': 'http_port', 'lang_key': "http_port"},
				{'selector': 'https_port', 'lang_key': "https_port"},
				{'selector': 'mode', 'lang_key': "mode"},
				{'selector': 'session_count', 'lang_key': "session_count"},
				{'selector': 'connection', 'lang_key': "connection"},
            ],
	    'default_columns': ['name', 'status', /*'hc_status',*/ 'vserver', 'protocol', 'http_port', 'https_port', 'mode', 'session_count', 'connection'],
            'column_filters': {
                'enabled': true,
		'exempts': ['status', /*'hc_status',*/ 'vserver', 'protocol', 'http_port', 'https_port', 'mode', 'session_count', 'connection'],
		'server_side_reload': server_side_reload
            },
            'menu_items': gen_menu(),
            'options':{
		'hide_create_button': true,
		'hide_edit_button': true,
		'hide_delete_button': true,
                'resize_to_parent': 'false',
                'fixed_header': 'false',
            },
	    'paging': {
		    'enabled': false,
		    'server_side': true
	    },
	    'format_fn':{
			'status': status_format_fn,
			//'hc_status': hc_status_format_fn,
			'vserver': vserver_format_fn
	    },
            'callbacks': {
                'load': content_loaded
            }   
        };

        var $container = $("#content");
	$container.height($j(window).height()).qlist(qlist_settings);
   }
   return {configure: setup_qlist};
})(jQuery);
