var module_list = (function($) {
	'use strict';
	function lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data,flt_lang);
	}

	function mobile_api_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		var status = row_data["mobile-app-identification"];
		return (status === "enable") ? data : "";
	}

	function waf_profile_onclick_clone(qlist, elems)
	{
		var clone_url = '/waf/profile_offline/dlgcopy';
		var mkey = qlist_get_row_attr(elems, 'mkey');
		if(mkey){
			clone_url += '?mkey=' + encodeURIComponent(mkey);
			if(vdom) clone_url += '&vdom=' + encodeURIComponent(vdom);
			window.location.href = clone_url;
		}
	}

	function content_loaded(qlist)
	{
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function waf_profile_handle_selection_change(q)
	{
		// Let the default handler handle the standard buttons.
		qlist_handle_selection_change(q);

		var aElems = q.get_checked_rows();
		var mi_edit = $("#mi_edit_" + q.prefix);
		var mi_clone = $("#mi_clone_" + q.prefix);
		var mi_view = $("#mi_view_" + q.prefix);
		if(!is_rw_admin)
		{
			qmenu_enable_button(mi_view, true, q);
			return;
		}

		if(aElems.length == 1 && parseInt(qlist_get_row_attr(aElems[0], 'can_clone')) == 1)
			qmenu_enable_button(mi_clone, true, q);
		else
			qmenu_enable_button(mi_clone, false, q);

		if (aElems.length == 1 && parseInt(qlist_get_row_attr(aElems[0], 'default_flag')) == 1)
		{
			qmenu_enable_button(mi_view, true, q);
			qmenu_enable_button(mi_edit, false, q);
		}else{
			qmenu_enable_button(mi_view, false, q);
		}
	}

	function gen_qlist(datas){
		var menu_items = {};
		if(is_rw_admin){
			menu_items = {
				'mi_view': {
					'id': 'mi_view',
					'label': $.getInfo('view'),
					'class': 'tool_view',
					'handler': edit_click,
				},
				'mi_clone': {
					'id': 'mi_clone',
					'label': $.getInfo('Copy',flt_lang),
					'class': 'tool_clone',
					'handler': waf_profile_onclick_clone,
				}
			};
		}		
		var columns = [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name',flt_lang)},
				{'selector': 'http-session-management', 'lang_key': $j.getInfo('session_manage',flt_lang)},
				{'selector': 'signature-rule', 'lang_key': $j.getInfo('signature_rule',flt_lang)},
				{'selector': 'parameter-validation-rule', 'lang_key': $j.getInfo('parameter_validation_rule',flt_lang)},

				{'selector': 'x-forwarded-for-rule', 'lang_key': $j.getInfo('x_forwarded_for_rule',flt_lang)},
				{'selector': 'custom-access-policy', 'lang_key': $j.getInfo('custom_access_policy',flt_lang)},
				{'selector': 'file-upload-policy', 'lang_key': $j.getInfo('file_upload_restriction_policy',flt_lang)},
				{'selector': 'http-protocol-parameter-restriction', 'lang_key': $j.getInfo('http_pro_par_res',flt_lang)},
				{'selector': 'url-access-policy', 'lang_key': $j.getInfo('url_access_policy',flt_lang)},
				{'selector': 'allow-method-policy', 'lang_key': $j.getInfo('allow_method_policy',flt_lang)},
				{'selector': 'brute-force-login', 'lang_key': $j.getInfo('brute_force_login',flt_lang)},
				{'selector': 'geo-block-list-policy', 'lang_key': $j.getInfo('geo_block_list',flt_lang)},
				{'selector': 'file-uncompress-rule', 'lang_key': $j.getInfo('file_uncompress_rule',flt_lang)},
				{'selector': 'data-analysis', 'lang_key': $j.getInfo('data_analytics',flt_lang)},
				{'selector': 'user-tracking-policy', 'lang_key': $j.getInfo('user_tracking', flt_lang)},
				{'selector': 'xml-validation-policy', 'lang_key': $j.getInfo('xml_protection', flt_lang)}
			];
		if(visibility_mobile){
			columns.push({'selector': 'mobile-api-protection', 'lang_key': $j.getInfo('map_policy', flt_lang)});
		}
		var settings = {
			'prefix': 'profile_offline_list',
			'source': datas,
			'handle_selection_change': waf_profile_handle_selection_change,
			'menu_items': menu_items,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'can_clone', selector: 'can_clone'},
				{name: 'default_flag', selector: 'can_view'},
			],
			'columns': columns,
			'column_filters': {
				'enabled': true,
				'exempts': ['id']
			},
			'default_columns':['id', 'name', 'http-session-management', 'signature-rule', 'parameter-validation-rule'],
			'search': { 'enabled': false },
			'format_fn': {
				'http-session-management': lang_format_fn,
				'data-analysis': lang_format_fn,
				'mobile-api-protection':mobile_api_format_fn
			},
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid: g_cmdb_table_id, vdom: vdom, _: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/waf/profile_offline/list?vdom='+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
