var module_list = (function($) {
	'use strict';

	var source;

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function handle_selection_change(q)
	{
		qlist_handle_selection_change(q);

		if(!is_rw_admin)
			return;

		var aElems = q.get_checked_rows();
		var mi_edit = $("#mi_edit_" + q.prefix);
		var mi_clone = $("#mi_clone_" + q.prefix);
		var mi_view = $("#mi_view_" + q.prefix);

		if(aElems.length == 1 && parseInt(qlist_get_row_attr(aElems[0], 'can_clone')) == 1)
			qmenu_enable_button(mi_clone, true, q);
		else
			qmenu_enable_button(mi_clone, false, q);

		if (aElems.length == 1 && parseInt(qlist_get_row_attr(aElems[0], 'default_flag')) == 1)
		{
			qmenu_enable_button(mi_view, true, q);
			qmenu_enable_button(mi_edit, false, q);
		}else{
			qmenu_enable_button(mi_view, false, q);
		}
	}

	function onclick_clone(qlist, aElems)
	{
		if (aElems.length != 1) return;

		var mkey = aElems[0].getAttribute("mkey");

		if(mkey)
			window.location.href = "/prot/data_type_group/dlgcopy?mkey=" + encodeURIComponent(mkey);
	}

	function gen_qlist(datas){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		source = datas;

		var menu_items = {};
		if(is_rw_admin){
			menu_items = {
				'mi_view': {
					'id': 'mi_view',
					'label': $.getInfo('view',fgt_lang),
					'class': 'tool_view',
					'handler': edit_click,
				},
				'mi_clone': {
					'id': 'mi_clone',
					'label': $.getInfo('clone',fgt_lang),
					'class': 'tool_clone',
					'handler': onclick_clone,
				}
			};
		}

		var qlist_settings = {
			'prefix': 'prot_data_type_grp',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'menu_items': menu_items,
			'handle_selection_change': handle_selection_change,
			'row_attr': [
			{name: 'mkey', selector: 'name'},
			{name: 'q_ref', selector: 'q_ref'},
			{name: 'can_clone', selector: 'can_clone'},
			{name: 'default_flag', selector: 'can_view'}
			],
			'columns': [
			{'selector': 'id', 'lang_key': '#'},
			{'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
			{'selector': 'sz_type-list', 'lang_key': $j.getInfo("members",flt_lang)}
			],
			'default_columns':['id', 'name', 'sz_type-list'],
			'column_filters': {
				'enabled': false
			},
			'options':{
				'ref_column': false,
				'sorting': false,
			},
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);

	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id, _: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/prot/data_type_group/list");
			}
		});
	}

	return {configure: configure};

})(jQuery);
