var module_list = (function($) {
	'use strict';

	function health_check_onclick_clone(qlist, elems)
	{
		var clone_url = '/prot/health_check/dlgcopy';
		var mkey = qlist_get_row_attr(elems, 'mkey');
		if(mkey){
			clone_url += '?mkey=' + encodeURIComponent(mkey);
			if(vdom) clone_url += '&vdom=' + encodeURIComponent(vdom);
			window.location.href = clone_url;
		}
	}

	function health_check_handle_selection_change(q)
	{
		// Let the default handler handle the standard buttons.
		qlist_handle_selection_change(q);

		var aElems = q.get_checked_rows();
		var mi_edit = $("#mi_edit_" + q.prefix);
		var mi_clone = $("#mi_clone_" + q.prefix);
		var mi_view = $("#mi_view_" + q.prefix);
		if(!is_rw_admin)
		{
			qmenu_enable_button(mi_view, true, q);
			return;
		}

		if(aElems.length == 1 && parseInt(qlist_get_row_attr(aElems[0], 'can_clone')) == 1)
			qmenu_enable_button(mi_clone, true, q);
		else
			qmenu_enable_button(mi_clone, false, q);

		if (aElems.length == 1 && parseInt(qlist_get_row_attr(aElems[0], 'default_flag')) == 1)
		{
			qmenu_enable_button(mi_view, true, q);
			qmenu_enable_button(mi_edit, false, q);
		}else{
			qmenu_enable_button(mi_view, false, q);
		}
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == 'undefined' ? -1 : g_cmdb_table_id;
	}

	function gen_qlist(datas){
		if (!window.fgt_lang || !fgt_lang["global"])
			$.addLang();
		var menu_items = {};
		if(is_rw_admin){
			menu_items = {
				'mi_view': {
					'id': 'mi_view',
					'label': $.getInfo('view',fgt_lang),
					'class': 'tool_view',
					'handler': edit_click,
				},
				'mi_clone': {
					'id': 'mi_clone',
					'label': $.getInfo('Copy',flt_lang),
					'class': 'tool_clone',
					'handler': health_check_onclick_clone,
				}
			};
		}		
		var settings = {
			'prefix': 'prot_health_check_list',
			'source': datas,
			'handle_selection_change': health_check_handle_selection_change,
			'menu_items': menu_items,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'can_clone', selector: 'can_clone'},
				{name: 'default_flag', selector: 'can_view'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $.getInfo('name',flt_lang)},
				{'selector': 'sz_health-list', 'lang_key': $.getInfo('count',flt_lang)},
			],
			'column_filters': {
				'enabled': false,
			},
			'paging': {
				'enabled': false,
			},
			'options': {
				'ref_column': false,
				'sorting': false,
			},
			'default_columns':['id', 'name', 'sz_health-list'],
			'search': { 'enabled': false },
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom, _: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/prot/health_check/list?vdom='+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
