var module_list = (function($) {
	'use strict';
	var OP_MODE_TP = (1<<0);
	var OP_MODE_INLINE = (1<<1)
	var OP_MODE_OFFLINE = (1<<2)
	var OP_MODE_TI = (1<<3)
	var OP_MODE_WCCP = (1<<4)
	var op_mode = OP_MODE_INLINE;
	var mode_lang = {
		'server-pool' : 'server_pool',
		'offline-protection' : 'offline_detection',
		'transparent-servers' : 'transparent_servers',
		'http-content-routing' : 'http_content_routing',
		'wccp-servers' : 'wccp_servers'
	};

	function enable_format_fn(td, col, row_data){

		var enable = parseInt(row_data['status_val']);
		var html = '<input type="checkbox" id="policy_enable' + row_data['id']  + '" name="policy_enable' + row_data['id'] + '"class="toggle-switch"'+ (enable? 'checked ' : '');
		if(is_rw_admin)
			html += 'onclick="window.location=\'/prot/policy/list?mkey='+ encodeURIComponent(row_data.name) +'&session_id='+ encodeURIComponent(session_id) +'\'"';
		else
			html += 'disabled';
		html += '/><label for="policy_enable' + row_data['id'] + '"></label>';

		return html;
	}

	function status_format_fn(td, col, row_data){
		var enable = parseInt(row_data['status_val']);
		var dmode = row_data['deployment-mode'];
		var status = 0;
		if (enable &&
			(((op_mode == OP_MODE_OFFLINE) && (dmode == 'offline-protection')) ||
				((op_mode == OP_MODE_INLINE) && (dmode != 'offline-protection')) ||
				(op_mode == OP_MODE_TP) ||
				(op_mode == OP_MODE_TI) ||
				(op_mode == OP_MODE_WCCP)
				))
			status = 1;
		else
			status = 0;

		if(status)
			return '<f-icon class="fa-link" title="'+ $j.getInfo('run',flt_lang) +'">' + '</f-icon>';
		else
			return '<f-icon class="fa-chain-broken" title="'+ $j.getInfo('idle',flt_lang) +'">' + '</f-icon>';
	}

	function lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data,fgt_lang);
	}

	function mode_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		var lang = mode_lang[data] ? mode_lang[data] : '';
		return (lang === '') ? lang : $.getInfo(lang,flt_lang);
	}

	function protocol_format_fn(td, col, row_data) {
		var http = row_data['service'] || '';
		var https = row_data['https-service'] || '';
		var ftp = row_data['protocol'] || '';

		if(ftp != '' && ftp == 'FTP')
			return 'FTP';
		else if(ftp != '' && ftp == 'ADFSPIP')
			return 'ADFSPIP';
		else if(ftp != '' && ftp == 'TCPPROXY')
			return 'TCPPROXY';
		else if(http != '' && https != '')
			return 'HTTP, HTTPS';
		else if(http != '' && https == '')
			return 'HTTP';
		else if(http == '' && https != '')
			return 'HTTPS';
		else
			return '';
	}

	function vip_format_fn(td, col, row_data) {
		var vserver = row_data['vserver'] || '';
		var vip = '';
		vserver_data.forEach(function(o) {
			if(vserver == o.name)
				vip = o.vip || '';
		});

		return vip;
	}

	function port_format_fn(td, col, row_data) {
		var vserver = row_data['vserver'] || '';
		var port = '';
		vserver_data.forEach(function(o) {
			if(vserver == o.name)
				port = o.interface || '';
		});
		return port;
	}
	function profile_format_fn(td, col, row_data) {
		var ftp = row_data['protocol'] || '';
		var profile = row_data['web-protection-profile'] || '';
		var ftp_profile = row_data['ftp-protection-profile'] || '';
		if(ftp != '' && ftp == 'FTP')
			return ftp_profile;
		return profile;
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == 'undefined' ? -1 : g_cmdb_table_id;
	}
    function http_new_onclick_action(type)                                                                            
    {     
    	window.location.href = create_url+'?protocol_type=http'; 	                                                                                  
    } 
    function adfs_new_onclick_action(type)                                                                            
    {     
    	window.location.href = create_url+'?protocol_type=adfs'; 	                                                                                  
    } 
    function ftp_new_onclick_action(type)                                                                            
    {
    	window.location.href = create_url+'?protocol_type=ftp';                                                                                     
    } 
    function tcp_new_onclick_action(type)                                                                            
    {
    	window.location.href = create_url+'?protocol_type=tcp';                                                                                     
    }    

	function gen_qlist(source){
		op_mode = operation_mode;
		if(!can_create_ftp)
		{
			source = source.filter(function(d) {
				return (d.protocol != 'FTP');
			});
		}	
		if(!can_create_adfs)
		{
			source = source.filter(function(d) {
				return (d.protocol != 'ADFSPIP');
			});
		}

		var menu_items = {};
		if(is_rw_admin)
		{
			if(can_create_ftp || can_create_adfs || can_create_tcp)
			{
				menu_items = {
					'mi_new': {
						'id': 'mi_new',
						'ctext': true,
						'class': 'tool_sprite tool_new',
						'label': $.getInfo('createnew',flt_lang),
						'text': $.getInfo('createnew',flt_lang),
						'force_drop_down' : true,
						'skip' : true,
						'submenu': {
							'mi_http_new':{
								'id': "mi_http_new",
								'ctxt': false,
								//'class': 'tool_sprite tool_new',
								'handler': http_new_onclick_action,
								'label': $.getInfo('http_new',flt_lang)
							},
						}
					}
				}
				if(can_create_ftp)
				{
					menu_items['mi_new']['submenu']['mi_ftp_new'] = {
						'id': "mi_ftp_new",
						'ctxt': false,
						//'class': 'tool_sprite tool_new',
						'handler': ftp_new_onclick_action,
						'label': $.getInfo('ftp_new',flt_lang)
					}
				}
				if(can_create_adfs) {
					menu_items['mi_new']['submenu']['mi_adfs_new'] = {
						'id': 'mi_adfs_new',
						'ctxt': false,
						'label': $.getInfo('adfs_new', flt_lang),
						'handler': adfs_new_onclick_action
					}
				}
				if(can_create_tcp) {
					menu_items['mi_new']['submenu']['mi_tcp_new'] = {
						'id': 'mi_tcp_new',
						'ctxt': false,
						'label': $.getInfo('tcp_new', flt_lang),
						'handler': tcp_new_onclick_action
					}
				}
			}
            
		}
		var settings = {
			'prefix': 'prot_policy_list',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'menu_items': menu_items,
			'paging': {
				'enabled': false,
			},
			'options': {
				'ref_column': false,
				'sorting': false,              
			},
			'search': { 'enabled': false },
			'callbacks': {
				'load': content_loaded
			},
			'format_fn': {
				'enable': enable_format_fn,
				'status': status_format_fn,
				'monitor-mode': lang_format_fn,
				'case-sensitive': lang_format_fn,
				'deployment-mode': mode_format_fn,
				'http2': lang_format_fn,
				'protocol': protocol_format_fn,
				'vip': vip_format_fn,
				'port': port_format_fn,
				'web-protection-profile' : profile_format_fn
			},
		};

		if(op_mode == OP_MODE_INLINE) {
			settings.columns = [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name',flt_lang)},
				{'selector': 'vserver', 'lang_key': $j.getInfo('vserver',flt_lang)},
				{'selector': 'vip', 'lang_key': $j.getInfo('vip', flt_lang)},
				{'selector': 'port', 'lang_key': $j.getInfo('port', flt_lang)},
				//{'selector': 'service', 'lang_key': $j.getInfo('service',flt_lang)},
				//{'selector': 'https-service', 'lang_key': $j.getInfo('https_service',flt_lang)},
				{'selector': 'protocol', 'lang_key': $j.getInfo('protocol', flt_lang)},
				{'selector': 'http2', 'lang_key': $j.getInfo('http2', flt_lang)},
				{'selector': 'allow-hosts', 'lang_key': $j.getInfo('allow_hosts',flt_lang)},
				{'selector': 'deployment-mode', 'lang_key': $j.getInfo('deploy_mode',flt_lang)},
				{'selector': 'web-protection-profile', 'lang_key': $j.getInfo('waf_profile',flt_lang)},
				//{'selector': 'waf-autolearning-profile', 'lang_key': $j.getInfo('waf_autolearning_profile',flt_lang)},
				{'selector': 'monitor-mode', 'lang_key': $j.getInfo('monitor_mode',flt_lang)},
				{'selector': 'case-sensitive', 'lang_key': $j.getInfo('case_sensitive',flt_lang)},
				{'selector': 'enable', 'lang_key': $j.getInfo('enable',flt_lang)},
				{'selector': 'status', 'lang_key': $j.getInfo('status',flt_lang)},
			];
			settings.column_filters = {
				'enabled': true,
				'exempts': ['id', 'protocol', 'deployment-mode', 'allow-hosts', 'monitor-mode', 'case-sensitive', 'enable', 'status']
			};
			settings.default_columns = ['id', 'name', 'vserver', 'vip', 'port', /*'service', 'https-service',*/ 'protocol', 'deployment-mode', 'web-protection-profile', 'monitor-mode', 'enable', 'status'];
		}
		else if(op_mode == OP_MODE_OFFLINE) {
			settings.columns = [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name',flt_lang)},
				{'selector': 'server-pool', 'lang_key': $j.getInfo('server_pool',flt_lang)},
				{'selector': 'allow-hosts', 'lang_key': $j.getInfo('allow_hosts',flt_lang)},
				{'selector': 'data-capture-port', 'lang_key': $j.getInfo('port_data',flt_lang)},
				{'selector': 'block-port', 'lang_key': $j.getInfo('blockport',flt_lang)},
				{'selector': 'deployment-mode', 'lang_key': $j.getInfo('deploy_mode',flt_lang)},
				{'selector': 'web-protection-profile', 'lang_key': $j.getInfo('waf_profile',flt_lang)},
				//{'selector': 'waf-autolearning-profile', 'lang_key': $j.getInfo('waf_autolearning_profile',flt_lang)},
				{'selector': 'monitor-mode', 'lang_key': $j.getInfo('monitor_mode',flt_lang)},
				{'selector': 'case-sensitive', 'lang_key': $j.getInfo('case_sensitive',flt_lang)},
				{'selector': 'enable', 'lang_key': $j.getInfo('enable',flt_lang)},
				{'selector': 'status', 'lang_key': $j.getInfo('status',flt_lang)},
			];
			settings.column_filters = {
				'enabled': true,
				'exempts': ['id', 'allow-hosts', 'block-port', 'deployment-mode', 'monitor-mode', 'case-sensitive', 'enable', 'status']
			};
			settings.default_columns = ['id', 'name', 'server-pool', 'data-capture-port', 'deployment-mode', 'web-protection-profile', 'monitor-mode', 'enable', 'status'];
		}
		else if(op_mode == OP_MODE_TP || op_mode == OP_MODE_TI) {
			settings.columns = [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name',flt_lang)},
				{'selector': 'server-pool', 'lang_key': $j.getInfo('server_pool',flt_lang)},
				{'selector': 'v-zone', 'lang_key': $j.getInfo('vzone',flt_lang)},
				{'selector': 'allow-hosts', 'lang_key': $j.getInfo('allow_hosts',flt_lang)},
				{'selector': 'deployment-mode', 'lang_key': $j.getInfo('deploy_mode',flt_lang)},
				{'selector': 'web-protection-profile', 'lang_key': $j.getInfo('waf_profile',flt_lang)},
				//{'selector': 'waf-autolearning-profile', 'lang_key': $j.getInfo('waf_autolearning_profile',flt_lang)},
				{'selector': 'monitor-mode', 'lang_key': $j.getInfo('monitor_mode',flt_lang)},
				{'selector': 'case-sensitive', 'lang_key': $j.getInfo('case_sensitive',flt_lang)},
				{'selector': 'enable', 'lang_key': $j.getInfo('enable',flt_lang)},
				{'selector': 'status', 'lang_key': $j.getInfo('status',flt_lang)},
			];
			settings.column_filters = {
				'enabled': true,
				'exempts': ['id', 'allow-hosts', 'deployment-mode', 'monitor-mode', 'case-sensitive', 'enable', 'status']
			};
			settings.default_columns = ['id', 'name', 'server-pool', 'v-zone', 'deployment-mode', 'web-protection-profile', 'monitor-mode', 'enable', 'status'];
		}
		else if(op_mode == OP_MODE_WCCP) {
			settings.columns = [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name',flt_lang)},
				{'selector': 'server-pool', 'lang_key': $j.getInfo('server_pool',flt_lang)},
				{'selector': 'allow-hosts', 'lang_key': $j.getInfo('allow_hosts',flt_lang)},
				{'selector': 'deployment-mode', 'lang_key': $j.getInfo('deploy_mode',flt_lang)},
				{'selector': 'web-protection-profile', 'lang_key': $j.getInfo('waf_profile',flt_lang)},
				//{'selector': 'waf-autolearning-profile', 'lang_key': $j.getInfo('waf_autolearning_profile',flt_lang)},
				{'selector': 'monitor-mode', 'lang_key': $j.getInfo('monitor_mode',flt_lang)},
				{'selector': 'case-sensitive', 'lang_key': $j.getInfo('case_sensitive',flt_lang)},
				{'selector': 'enable', 'lang_key': $j.getInfo('enable',flt_lang)},
				{'selector': 'status', 'lang_key': $j.getInfo('status',flt_lang)},
			];
			settings.column_filters = {
				'enabled': true,
				'exempts': ['id', 'allow-hosts', 'deployment-mode', 'monitor-mode', 'case-sensitive', 'enable', 'status']
			};
			settings.default_columns = ['id', 'name', 'server-pool', 'deployment-mode', 'web-protection-profile', 'monitor-mode', 'enable', 'status'];
		}

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {

		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,_: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				$(document).ready(function() { 
					gen_qlist(results.datas);
				}); 
			} else {
				error_handler(results.msg_id, "/prot/policy/list");
			}
		});
	}

	return {configure: configure};

})(jQuery);
