var module_list = (function($) {
	'use strict';

	var source;

	function content_loaded(qlist) 
	{
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}
	
	function view_click(q)
	{
		var aElems = q.get_checked_rows();
		if (aElems.length != 1) return;

		var mkey = aElems[0].getAttribute("mkey");
		window.location.href = "/prot/suspicious_url_rule/dlg?mkey=" + mkey; 
	}

	function clone_click(q)
	{
		var aElems = q.get_checked_rows();
		if (aElems.length != 1) return;

		var mkey = aElems[0].getAttribute("mkey");
		window.location.href = "/prot/suspicious_url_rule/dlgcopy?mkey=" + mkey;	
	}
	
	function prot_susurl_handle_selection_change(q)
	{
		qlist_handle_selection_change(q);

		var aElems = q.get_mixed_checked_rows();
		if(!is_rw_admin)
		{
			qmenu_enable_button($("#mi_view_" + q.prefix), true, q);
			return;
		}

		if(aElems.length == 1 && parseInt(aElems[0].getAttribute("can_clone")) == 1)
			qmenu_enable_button($("#mi_clone_" + q.prefix), true, q);
		else
			qmenu_enable_button($("#mi_clone_" + q.prefix), false, q);

		if (aElems.length == 1 && parseInt(aElems[0].getAttribute("can_v")) == 1)
		{
			qmenu_enable_button($("#mi_view_" + q.prefix), true, q);
			qmenu_enable_button($("#mi_edit_" + q.prefix), false, q);
		}else{
			qmenu_enable_button($("#mi_view_" + q.prefix), false, q);
		}
	}

	function gen_qlist(datas) 
	{
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();

		source = datas;

		var menu_items = [];
		if(is_rw_admin)
		{
			menu_items = {
				'mi_view': {
					'id': 'mi_view',
					'class': 'tool_sprite tool_view',
					'handler': view_click,
					'label': qed_strtbl.view
				},
				'mi_clone': {
					'id': 'mi_clone',
					'class': 'tool_sprite tool_clone',
					'handler': clone_click,
					'label': qed_strtbl.clone
				}
			};
		}

		var qlist_settings = {
			'prefix': 'suspicious_url_list',
    			'source': source,
    			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
			{name: 'can_clone', selector: 'can_clone'},
			{name: 'can_v', selector: 'can_view'}
			],
			'columns': [
			{'selector': 'id', 'lang_key': '#'},
			{'selector': 'name', 'lang_key': $j.getInfo("name", flt_lang)},
			{'selector': 'custom-susp-url-rule', 'lang_key': $j.getInfo("cus_susp_url_rule", flt_lang)},
			{'selector': 'sz_type-list', 'lang_key': $j.getInfo("members", flt_lang)},
			],
			'default_columns': ['id', 'name', 'custom-susp-url-rule', 'sz_type-list'],
			'column_filters': {
				'enabled': false
			},
			'menu_items': menu_items,
			'options': {
				'ref_column': false,
				'sorting': false,
			},
			'handle_selection_change': prot_susurl_handle_selection_change,
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);
	}

	function configure() 
	{
		$j.getJSON('/cli-direct-action', {table_gid: g_cmdb_table_id, vdom: vdom,_: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			}
			else
			{
				error_handler(results.msg_id, "/prot/suspicious_url_rule/list");
			}
		});
	}

	return {configure: configure};
})(jQuery);
