var module_list = (function($) {
	'use strict';

	var source;

	function setup_qlist()
	{
		$.ajax({
			'url': '/prot/vserver/list/json?table_gid='+g_cmdb_table_id,
			'dataType': 'json',
			'success': function(response)
			{
				if(response.status == 1)
				{
					source = response.results;
					gen_qlist();
				}
				else if(response.status == 0)
					error_handler(response.msg_id, "/prot/vserver/list");
			},
			'cache': false
		});
	}

	function status_format_fn($td, col, row_data)
	{
		var html = '';
		html += '<input type="checkbox" id="vserver_enable' + row_data['id'] + '" name="vserver_enable' + row_data['id'] + '" class="toggle-switch" onclick="javascript:window.location=\'/prot/vserver/list?mkey='+row_data.name+'&session_id='+session_id+'\'" ';
		if(row_data.status == 'enable')
			html += 'checked';
		html += ' /><label for="vserver_enable' + row_data['id'] + '"></label>';
		return html;
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function gen_qlist(){
		var qlist_settings = {
			'prefix': 'vserver',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
				{'selector': 'count', 'lang_key': $j.getInfo("count",fgt_lang)},
			],
			'default_columns':['id','name', 'count'],
			'column_filters': {
				'enabled': true,
				'exempts': ['id', 'count']
			},
			'format_fn': {
				'status' : status_format_fn,
			},
//			'handle_selection_change': selection_changed,
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);

	}

	return {configure: setup_qlist};

})(jQuery);
