var module_list = (function($) {
        'use strict';
        var type_lang=['pst_ip', 'pst_cookie', 'asp_sessionid', 'php_sessionid', 'jsp_sessionid', 
        'insert_cookie', 'http_header', 'url_param', 'rewrite_cookie', 'embeded_cookie', 'ssl_sessionid'];

        function type_format_fn(td, col, row_data){
                var data = row_data['type_val'];
                return (data === "") ? data : $j.getInfo(type_lang[data-1],flt_lang);
        }
        function timeout_format_fn(td, col, row_data){
                var data = row_data['type_val'];
                return (data === '9' || data == '10') ? '': row_data[col.selector];
        }
        function cookie_format_fn(td, col, row_data){
                var data = row_data['type_val'];
                return (data === '2' || data === '6' || data === '9' || data == '10') ? row_data[col.selector]: '';
        }           
        function ip_format_fn(td, col, row_data){
                var data = row_data['type_val'];
                return (data === '1') ? row_data[col.selector]: '';
        }            
        function header_format_fn(td, col, row_data){
                var data = row_data['type_val'];
                return (data === '7') ? row_data[col.selector]: '';
        }             
        function url_format_fn(td, col, row_data){
                var data = row_data['type_val'];
                return (data === '8') ? row_data[col.selector]: '';
        }       
        var source;

        function setup_qlist()
        {
                $.ajax({
                        'url': '/cli-direct-action?table_gid='+g_cmdb_table_id,
                        'dataType': 'json',
                        'success': function(response)
                        {
                                if(response.status == 1)
                                {
                                        source = response.datas;
                                        gen_qlist();
                                }
                                else if(response.status == 0)
                                        error_handler(response.msg_id, "/prot/pst_policy/list");
                        },
                        'cache': false
                });
        }

        function content_loaded(qlist) {
                qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
        }

	function gen_qlist(){
		var qlist_settings = {
                        'prefix': 'pst_policy',
                        'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
                        'row_attr': [
                                {name: 'mkey', selector: 'name'},
                                {name: 'q_ref', selector: 'q_ref'},
                        ],
                        'columns': [
                                {'selector': 'id', 'lang_key': '#'},
                                {'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
                                {'selector': 'type', 'lang_key': $j.getInfo("type",flt_lang)},
                                {'selector': 'cookie-name', 'lang_key': $j.getInfo("cookie_name",flt_lang)},
                                {'selector': 'timeout', 'lang_key': $j.getInfo('timeout', flt_lang)},
                                {'selector': 'ipv4-netmask', 'lang_key': $j.getInfo("ipv4_mask",flt_lang)},
                                {'selector': 'ipv6-mask-length', 'lang_key': $j.getInfo("ipv6_mask",flt_lang)},
                                {'selector': 'http-header', 'lang_key': $j.getInfo("header_name",flt_lang)},
				{'selector': 'url-parameter', 'lang_key': $j.getInfo("parameter_name",flt_lang)}
                        ],
                        'default_columns':['id', 'name', 'type', 'cookie-name', 'timeout'],
                        'column_filters': {
                                'enabled': true,
                                'exempts': ['id', 'timeout', 'ipv4-netmask', 'ipv6-mask-length']
                        },
//                        'handle_selection_change': selection_changed,
                        'callbacks': {
                                'load': content_loaded
                        },
                        'format_fn': {
                                'type': type_format_fn,
                                'timeout': timeout_format_fn,
                                'cookie-name': cookie_format_fn,
                                'ipv4-netmask': ip_format_fn,
                                'ipv6-mask-length': ip_format_fn,
                                'http-header': header_format_fn,
                                'url-parameter': url_format_fn,
                        }
                };

                var $container = $("#content");
                $container.qlist(qlist_settings);

        }

        return {configure: setup_qlist};

})(jQuery);
