/****************
 * route policy
 * by shuyusun
 * **************/

var module_list = (function($){
	'use strict'

	var source;
	function setup_qlist()
	{
		$.ajax({
			'url': '/cli-direct-action?table_gid='+g_cmdb_table_id,
			'dataType': 'json',
			'success': function(response)
			{
				if(response.status == 1)
				{
					source = response.datas;
					gen_qlist();
				}
				else if(response.status == 0)
					error_handler(response.msg_id, "/system/network/routerpolicy");
			},
			'cache': false
		});
	}

	function content_loaded(qlist) 
	{
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
		qlist.cr_del_url = '/delete?type=0';
	}
	
	function gen_qlist(){
        if (!window.fgt_lang || !fgt_lang["global"])
            $j.addLang();
        var qlist_settings = {
            'prefix': 'policy_status',
            'source': source,
	    	'cr_new_url': create_url,
	    	'cr_edit_url': edit_url,
            'row_attr': [
                    {name: 'mkey', selector: 'id'},
                    {name: 'can_edit', selector: 'can_edit'},
                    {name: 'type', selector: 'type'},
                    {name: 'ref', selector: 'q_ref'},
                    {name: 'status', selector: 'status'}
            ],
	    'columns': [
		    {'selector': 'id', 'lang_key': '#'},
		    {'selector': 'iif', 'lang_key': $j.getInfo("iif",flt_lang)},
		    {'selector': 'oif', 'lang_key': $j.getInfo("oif",flt_lang)},
		    {'selector': 'src', 'lang_key': $j.getInfo("src",flt_lang)},
		    {'selector': 'dst', 'lang_key': $j.getInfo("dst",flt_lang)},
		    {'selector': 'gateway', 'lang_key': $j.getInfo("gateway",flt_lang)},
		    {'selector': 'priority', 'lang_key': $j.getInfo("pref",flt_lang)},
		    ],
	    	'default_columns': ['id', 'iif', 'oif', 'src', 'dst', 'gateway', 'priority'],
            'callbacks': {
                'load': content_loaded
            }   
        };

        var $container = $("#content");
        $container.qlist(qlist_settings);
   }
   return {configure: setup_qlist};
})(jQuery);
