var module_list = (function($) {
	'use strict';
	var OP_MODE_TP = (1<<0);
	var OP_MODE_INLINE = (1<<1)
	var OP_MODE_OFFLINE = (1<<2)
	var OP_MODE_TI = (1<<3)
	var OP_MODE_WCCP = (1<<4)
	var op_mode = OP_MODE_INLINE;
	function setup_qlist()
	{
		$j.getJSON('/cli-direct-action', {table_gid: g_cmdb_table_id, vdom: vdom,_: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			}
			else
			{
				error_handler(results.msg_id, "/prot/server_pool/list");
			}
		});
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function type_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		var key = '';
		if(data == 'reverse-proxy')
			key = 'type_inline';
		else if(data == 'offline-protection')
			key = 'type_offline';
		else if(data == 'transparent-servers-for-tp')
			key = 'type_tp';
		else if(data == 'transparent-servers-for-ti')
			key = 'type_ti';
		else if(data == 'transparent-servers-for-wccp')
			key = 'type_wccp';

		return $j.getInfo(key, flt_lang);
	}

	function mode_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		var type = row_data['type'];
		var key = '';
		if(data == 'enable')
			key = 'server_balance';
		else if(data == 'disable')
			key = 'single_server';

		if(type != 'reverse-proxy')
			return '';
		else
			return $j.getInfo(key, flt_lang);
	}

	function algo_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		var type = row_data['type'];
		var str_balance = 'server-balance';
		var balance = row_data[str_balance];

		var key = '';
		if(data == 'round-robin')
			key = 'algo_rr';
		else if(data == 'weighted-round-robin')
			key = 'algo_wrr';
		else if(data == 'least-connections')
			key = 'algo_lc';
		else if(data == 'uri-hash')
			key = 'algo_hu';
		else if(data == 'full-uri-hash')
			key = 'algo_hfu';
		else if(data == 'host-hash')
			key = 'algo_hh';
		else if(data == 'host-domain-hash')
			key = 'algo_hhd';
		else if(data == 'src-ip-hash')
			key = 'algo_hdi';

		if(type == 'reverse-proxy' && balance == 'enable')
			return $j.getInfo(key, flt_lang);
		else
			return '';
	}

	function health_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		var bal = row_data['server-balance'];
		if(bal == 'disable')
			return '';
		else
			return data;
	}

	function serverpool_onclick_create_http()
	{
		window.location.href = '/prot/server_pool/dlg';
	}

	function serverpool_onclick_create_ftp()
	{
		window.location.href = '/prot/server_pool/ftp_dlg';
	}
	function serverpool_onclick_create_adfs()
	{
		window.location.href = '/prot/server_pool/adfs_dlg';
	}
	function serverpool_onclick_create_tcp()
	{
		window.location.href = '/prot/server_pool/tcp_dlg';
	}

	function edit_click(qlist, elems)
	{
		var mkey = qlist_get_row_attr(elems, 'mkey'),
			protocol = qlist_get_row_attr(elems, 'protocol');
		var url;

		if(mkey)
		{
			mkey = encodeURIComponent(mkey);

			if(protocol == 'HTTP')
				url = '/prot/server_pool/dlg';
			else if(protocol == 'FTP')
				url = '/prot/server_pool/ftp_dlg';
			else if(protocol == 'TCPPROXY')
				url = '/prot/server_pool/tcp_dlg';
			else
				url = '/prot/server_pool/adfs_dlg'

			window.location.href = url + "?mkey=" + mkey;
		}
	}

	function gen_qlist(source){
		op_mode = operation_mode;
		if(!can_create_ftp)
		{
			source = source.filter(function(d) {
				return (d.protocol != 'FTP');
			});
		}
		if(!can_create_adfs)
		{
			source = source.filter(function(d) {
				return (d.protocol != 'ADFSPIP');
			});
		}
		if(!can_create_tcp)
		{
			source = source.filter(function(d) {
				return (d.protocol != 'TCPPROXY');
			});
		}

		var menu_items = {};
		if(is_rw_admin)
		{
			if(can_create_ftp || can_create_adfs || can_create_tcp)
			{
				menu_items = {
					'mi_new': {
						'id': 'mi_new',
						'ctxt': false,
						'class': 'tool_sprite tool_new',
						'force_drop_down': true,
						'label': $.getInfo('create',flt_lang),
						'text': $.getInfo('create',flt_lang),
						'submenu': {
							'mi_create_http': {
								'id': 'mi_create_http',
								'ctxt': false,
								'label': $.getInfo('create_http', flt_lang),
								'handler': serverpool_onclick_create_http
							},
						}
					},
					'mi_edit': {
						'id': 'mi_edit',
						'ctxt': true,
						'class': 'tool_sprite tool_edit',
						'handler': edit_click,
						'label': $.getInfo('edit', flt_lang)
					},
					'mi_del': {
						'id': 'mi_del',
						'ctxt': true,
						'class': 'tool_sprite tool_delete',
						'handler': qlist_onclick_delete,
						'label': $.getInfo('delete', flt_lang)
					}
				};
				if(can_create_adfs){
					menu_items['mi_new']['submenu']['mi_create_adfs'] = {
						'id': 'mi_create_adfs',
						'ctxt': false,
						'label': $.getInfo('create_adfs', flt_lang),
						'handler': serverpool_onclick_create_adfs
					};
				}
				if(can_create_ftp)
					menu_items['mi_new']['submenu']['mi_create_ftp'] = {
						'id': 'mi_create_ftp',
						'ctxt': false,
						'label': $.getInfo('create_ftp', flt_lang),
						'handler': serverpool_onclick_create_ftp
					};
				if(can_create_tcp)
					menu_items['mi_new']['submenu']['mi_create_tcp'] = {
						'id': 'mi_create_tcp',
						'ctxt': false,
						'label': $.getInfo('create_tcp', flt_lang),
						'handler': serverpool_onclick_create_tcp
					};
			}
			else
			{
				menu_items = {
					'mi_new': {
						'id': 'mi_new',
						'ctxt': false,
						'class': 'tool_sprite tool_new',
						'handler': serverpool_onclick_create_http,
						'label': $.getInfo('create',flt_lang)
					},
					'mi_edit': {
						'id': 'mi_edit',
						'ctxt': true,
						'class': 'tool_sprite tool_edit',
						'handler': edit_click,
						'label': $.getInfo('edit', flt_lang)
					},
					'mi_del': {
						'id': 'mi_del',
						'ctxt': true,
						'class': 'tool_sprite tool_delete',
						'handler': qlist_onclick_delete,
						'label': $.getInfo('delete', flt_lang)
					}
				};

			}
		}

		var qlist_settings = {
			'prefix': 'server_pool',
			'source': source,
			'menu_items': menu_items,
			'options': {
				hide_default_buttons: true
			},
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
				{name: 'protocol', selector: 'protocol'}
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
				{'selector': 'type', 'lang_key': $j.getInfo("type",flt_lang)},
				{'selector': 'protocol', 'lang_key': $j.getInfo("protocol", flt_lang)},
				{'selector': 'server-balance', 'lang_key': $j.getInfo("single_balance",flt_lang)},
				{'selector': 'health', 'lang_key': $j.getInfo('health', flt_lang)},
				{'selector': 'lb-algo', 'lang_key': $j.getInfo("algo",flt_lang)},
				{'selector': 'persistence', 'lang_key': $j.getInfo("pst_policy",flt_lang)},
				{'selector': 'sz_pserver-list', 'lang_key': $j.getInfo("pool_list",flt_lang)}
			],
			'default_columns':['id', 'name', 'type', 'protocol', 'server-balance', 'health', 'lb-algo', 'persistence', 'sz_pserver-list'],
			'column_filters': {
				'enabled': true,
				'exempts': ['id', 'server-balance', 'lb-algo', 'persistence', 'sz_pserver-list']
			},
			'callbacks': {
				'load': content_loaded,
				'dblclick': edit_click
			},
			'format_fn': {
				'type': type_format_fn,
				'server-balance': mode_format_fn,
				'lb-algo': algo_format_fn,
				'health': health_format_fn
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);

	}

	return {configure: setup_qlist};

})(jQuery);
