var module_list = (function($) {
	'use strict';

	var source;
	var alert_lang = {
		'none' : "alert_none",
		'fail' : "alert_fail",
		'success' : "alert_success",
		'all' : "alert_all"
	};
	var client_lang = {
		'http-auth' : 'http_auth',
		'html-form-auth' : 'html_form_auth',
		'client-cert-auth' : 'client_cert_auth',
		'saml-auth': 'saml_auth'
	};

	function g_lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data,fgt_lang);
	}

	function auth_format_fn(td, col, row_data){
		if(row_data['client-auth-method']=='client-cert-auth')
			return '';
		return row_data[col.selector];
	}

	function option_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		var options_lang = null;
		if(col.selector == 'alert-type')
			options_lang = alert_lang;
		else if(col.selector == 'client-auth-method')
			options_lang = client_lang;
		else
			return '';

		var lang = options_lang[data] ? options_lang[data] : '';
		return (lang === '') ? lang : $j.getInfo(lang,flt_lang);
	}

	function status_format_fn(td, col, row_data){

		var enable = parseInt(row_data['status_val']);
		var html = '<input type="checkbox" name="site_enable' + row_data['id'] + '" id="site_enable' + row_data['id'] + '" class="toggle-switch" '+ (enable? 'checked ' : '');
		if(is_rw_admin)
			html += 'onclick="window.location=\'/prot/site_publish_helper_rule/list?mkey='+ encodeURIComponent(row_data.name) +'&session_id='+ encodeURIComponent(session_id) +'&vdom='+encodeURIComponent(vdom)+'\'"';
		else
			html += 'disabled';
		html += '/><label for="site_enable' + row_data['id'] + '" ></label>';

		return html;
	}

	function html_encode_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === '') ? data : escapeHTML(data);
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function gen_qlist(datas){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		source = datas;

		var qlist_settings = {
			'prefix': 'site_pub_rule',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
			{name: 'mkey', selector: 'name'},
			{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
			{'selector': 'id', 'lang_key': '#'},
			{'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
			{'selector': 'published-site', 'lang_key': $j.getInfo("published_site",flt_lang)},
			{'selector': 'sso-support', 'lang_key': $j.getInfo("sso_support",flt_lang)},
			{'selector': 'alert-type', 'lang_key': $j.getInfo("alert_type",flt_lang)},
			{'selector': 'status_val', 'lang_key': $j.getInfo("status",flt_lang)},
			{'selector': 'path', 'lang_key': $j.getInfo("path",flt_lang)},
			{'selector': 'client-auth-method', 'lang_key': $j.getInfo("client_auth_method",flt_lang)},
			{'selector': 'auth-server-pool', 'lang_key': $j.getInfo("auth_pool",flt_lang)}
			],
			'default_columns':['id', 'name', 'published-site', 'sso-support', 'alert-type', 'status_val'],
			'column_filters': {
				'enabled': true,
				'exempts': ['id', 'name', 'sso-support', 'alert-type', 'status_val', 'client-auth-method', 'auth-server-pool']
			},
			'options':{
				'ref_column': false,
				'sorting': false,
			},
			'callbacks': {
				'load': content_loaded
			},
			'format_fn': {
				'sso-support': g_lang_format_fn,
				'alert-type': option_format_fn,
				'status_val': status_format_fn,
				'client-auth-method': option_format_fn,
				'auth-server-pool': auth_format_fn,
				'published-site': html_encode_format_fn,
				'path': html_encode_format_fn
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);

	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom, _: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/prot/site_publish_helper_rule/list?vdom="+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
