var module_list = (function($) {
    'use strict';

    function content_loaded(qlist) {
        qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
    }

    function type_format_fn(td, col, row_data) {
        var type = row_data[col.selector];
        var html = $j.getInfo(type, flt_lang);
        return html;
    }

    function gen_qlist(datas) {
        var settings = {
            'prefix': 'sys_cert_hpkp',
            'source': datas,
            'cr_new_url': create_url,
            'cr_edit_url': edit_url,
            'columns': [
                {'selector': 'id', 'lang_key': '#'},
                {'selector': 'name', 'lang_key': $j.getInfo('name', flt_lang) },
                {'selector': 'pin-sha256', 'lang_key': $j.getInfo('pin_sha256', flt_lang) },
                {'selector': 'max-age', 'lang_key': $j.getInfo('max_age', flt_lang) },
                {'selector': 'subdomains', 'lang_key': $j.getInfo('subdomains', flt_lang) },
                {'selector': 'report-uri', 'lang_key': $j.getInfo('report_uri', flt_lang) },
                {'selector': 'report-only', 'lang_key': $j.getInfo('report_only', flt_lang) },
            ],
            'column_filters': {
                'enabled': false
            },
            'options': {
                'ref_column': false,
                'sorting': false
            },
            'default_columns': ['id', 'name', 'pin-sha256', 'max-age', 'subdomains', 'report-uri', 'report-only'],
            'row_attr': [
                { name: 'mkey', selector: 'name' },
                { name: 'q_ref', selector: 'q_ref' },
            ],
            'callbacks': {
                'load': content_loaded
            },
            'format_fn': {
                'subdomains': type_format_fn,
                'report-only': type_format_fn
            }
        };

        var $container = $("#content");
        $container.qlist(settings);
    }

    function configure() {
        $j.getJSON('/cli-direct-action', { table_gid: g_cmdb_table_id, _: new Date().getTime() }, function(results) {
            if (results.status == 1) {
                gen_qlist(results.datas);
            } else {
                error_handler(results.msg_id, "/system/cert_hpkp/list");
            }
        });
    }

    return { configure: configure };

})(jQuery);
