var module_list = (function($) {
	'use strict';

	function cert_onclick_import()
	{
		window.location.href = "/system/interimport";
	}

	function cert_onclick_view(qlist, elems)
	{
		var mkey = qlist_get_row_attr(elems, 'mkey');

		window.location.href = "/sys/cert/interview?q=6&seq=" + mkey;
	}

	function cert_inter_selection_change(qlist)
	{
		// Let the default handler handle the standard buttons.
		qlist_handle_selection_change(qlist);

		var aElems = qlist.get_checked_rows();
		var mi_import = $('#mi_import_' + qlist.prefix);
		var mi_view = $('#mi_view_' + qlist.prefix);

		qmenu_enable_button(mi_import, true, qlist);

		if (aElems.length == 1 && parseInt(aElems[0].getAttribute("can_view")) == 1)
			qmenu_enable_button(mi_view, true, qlist);
		else
			qmenu_enable_button(mi_view, false, qlist);
	}


	function gen_qlist(datas){

		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'mi_import': {
					'id': 'mi_import',
					'label': cert_strtbl.importstr,
					'class': 'tool_import',
					'handler': cert_onclick_import,
					'ctxt': false
				},
				'mi_view': {
					'id': 'mi_view',
					'label': cert_strtbl.view,
					'class': 'tool_view',
					'handler': cert_onclick_view
				},
			};
		}
		else
		{
			menu_items = {
				'mi_view': {
                                        'id': 'mi_view',
                                        'label': cert_strtbl.view,
                                        'class': 'tool_view',
                                        'handler': cert_onclick_view
                                }
			};
		}

		var settings = {
			'prefix': 'sys_cert_inter_list',
			'source': datas,
			'menu_items': menu_items,
			'row_attr': [
				{name: 'can_view', selector: 'can_view'},
                        ],
			'columns': [
				{'selector': 'name', 'lang_key': $j.getInfo('cert_name',flt_lang)},
				{'selector': 'cert_subject', 'lang_key': $j.getInfo('cert_subject',flt_lang)},
				{'selector': 'cert_issuer', 'lang_key': $j.getInfo('cert_issuer',flt_lang)},
				{'selector': 'cert_edate', 'lang_key': $j.getInfo('cert_edate',flt_lang)},
			],
			'column_filters': {
				'enabled': true,
				'exempts': ['cert_edate']
			},
			'paging': {
				'enabled': false,
			},
			'options': {
				'ref_column': false,
				'sorting': false,
				'hide_create_button': true,
				'hide_edit_button': true,
			},
			'default_columns':['name', 'cert_subject', 'cert_issuer', 'cert_edate'],
			'handle_selection_change': cert_inter_selection_change,
			'search': { 'enabled': false },
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/system/cert_inter/list/json', {_: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/system/cert_inter/list");
			}
		});
	}

	return {configure: configure};

})(jQuery);
