var module_list = (function($) {
        'use strict';
	
	if (!window.fgt_lang || !fgt_lang["global"])
		$j.addLang();
	$j.addLang('/waf/certificate/lang', 'certificate');
        var source;
	var columns = [
		{'selector': 'name', 'lang_key': $j.getInfo("cert_name",fgt_lang)},
		{'selector': 'subject', 'lang_key': $j.getInfo("cert_subject",fgt_lang)},
		{'selector': 'issuer', 'lang_key': $j.getInfo("cert_issuer",fgt_lang)},
		{'selector': 'expires', 'lang_key': $j.getInfo('cert_edate', fgt_lang)},
		{'selector': 'comment', 'lang_key': $j.getInfo("cert_comment",fgt_lang)},
		{'selector': 'status', 'lang_key': $j.getInfo('cert_sta', fgt_lang)}
	];
	var default_columns = ['name', 'subject', 'issuer', 'expires', 'comment', 'status'];
	var filter_exempts = ['expires', 'comment', 'status'];

        function setup_qlist()
        {
                $.ajax({
                        'url': '/system/cert_signca/list/json',
                        'dataType': 'json',
                        'success': function(response)
                        {
                                if(response.status == 1)
                                {
                                        source = response.results;
                                        gen_qlist();
                                }
                                else if(response.status == 0)
                                        error_handler(response.msg_id, "/system/cert_signca/list");
                        },
                        'cache': false
                });
        }

	function cert_onclick_import()
	{
		window.location.href = "/system/cert_signca/import?confirm=1";
	}

	function cert_onclick_view(qlist, elems)
	{
		var mkey = qlist_get_row_attr(elems, 'mkey');
		window.location.href = "/sys/cert/signcaview?q=10&seq=" + mkey;
	}

	function cert_onclick_config(qlist, elems)
	{
		var mkey = qlist_get_row_attr(elems, 'mkey');

		window.location.href = "/system/cert_signca/comment?mkey=" + mkey;
	}

	function cert_handle_selection_change(qlist)
	{
		qlist_handle_selection_change(qlist);

		var mi_import = $('#mi_import_' + qlist.prefix);
		var mi_view = $('#mi_view_' + qlist.prefix);
		var mi_config = $('#mi_config_' + qlist.prefix);

		var aElems = qlist.get_checked_rows();

		qmenu_enable_button(mi_import, true, qlist);

		if (aElems.length == 1 && parseInt(aElems[0].getAttribute("can_view")) == 1)
			qmenu_enable_button(mi_view, true, qlist);
		else
			qmenu_enable_button(mi_view, false, qlist);

		if (aElems.length == 1 && parseInt(qlist_get_row_attr(aElems[0], 'can_config')) == 1)
			qmenu_enable_button(mi_config, true, qlist);
		else
			qmenu_enable_button(mi_config, false, qlist)
	}

	function content_loaded(qlist)
	{
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function gen_qlist(){
		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'mi_import': {
					'id': 'mi_import',
					'label': cert_strtbl.importstr,
					'class': 'tool_import',
					'handler': cert_onclick_import,
					'ctxt': false
				},
				'mi_view': {
					'id': 'mi_view',
					'label': cert_strtbl.view,
					'class': 'tool_view',
					'handler': cert_onclick_view
				},
				'mi_config': {
					'id': 'mi_config',
					'label': cert_strtbl.edit_comment,
					'class': 'tool_edit',
					'handler': cert_onclick_config
				}
			};
		}
		else
		{
			menu_items = {
				'mi_view': {
                                        'id': 'mi_view',
                                        'label': cert_strtbl.view,
                                        'class': 'tool_view',
                                        'handler': cert_onclick_view
                                }
			};
		}

                var qlist_settings = {
                        'prefix': 'local_cert',
                        'source': source,
                        'row_attr': [
                                {name: 'mkey', selector: 'name'},
                                {name: 'q_ref', selector: 'q_ref'},
				{name: 'cert_type', selector: 'cert_type'},
				{name: 'can_view', selector: 'can_view'},
				{name: 'can_config', selector: 'can_config'}
                        ],
                        'columns': columns,
                        'default_columns':default_columns,
                        'column_filters': {
                                'enabled': true,
                                'exempts':filter_exempts 
                        },
			'menu_items': menu_items,
			'handle_selection_change': cert_handle_selection_change,
			'options': {
				'hide_create_button': true,
				'hide_edit_button': true
			},
			'callbacks': {
				'load': content_loaded
			}
                };

                var $container = $("#content");
                $container.qlist(qlist_settings);

        }

        return {configure: setup_qlist};

})(jQuery);
