var module_list = (function($) {
	'use strict';

	function lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data,fgt_lang);
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function gen_qlist(datas){		
		var settings = {
			'prefix': 'sys_cert_verify_list',
			'source': datas,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name',flt_lang)},
				{'selector': 'ca', 'lang_key': $j.getInfo('ca',flt_lang)},
				{'selector': 'crl', 'lang_key': $j.getInfo('crl',flt_lang)},
				{'selector': 'publish-dn', 'lang_key': $j.getInfo('dn_broadcast', flt_lang)},
				{'selector': 'strictly-need-cert', 'lang_key': $j.getInfo('need_cert', flt_lang)}
			],
			'column_filters': {
				'enabled': true,
				'exempts': ['id', 'publish-dn', 'strictly-need-cert']
			},
			'options': {
				'ref_column': false,
				'sorting': false,
			},
			'default_columns':['id', 'name', 'ca', 'crl', 'publish-dn'],
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'callbacks': {
				'load': content_loaded
			},
			'format_fn': {
				'publish-dn': lang_format_fn,
				'strictly-need-cert': lang_format_fn
			}
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id, _: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/system/cert_verify/list");
			}
		});
	}

	return {configure: configure};

})(jQuery);
