var module_list = (function($) {
	'use strict';
	var source;

	function enable_format_fn(td, col, row_data){
		if(!list_can_view) {
			var $parent = td.parent();
			$parent.addClass('disabled');
			$parent.attr('can_edit', false);
			$parent.attr('can_delete', false);
		}

		var status = row_data.status;
		var html = '<input type="checkbox" '+ ((status == 'enable')? 'checked ' : '');
		if(is_rw_admin && list_can_view)
			html += 'onclick="window.location=\'/system/decoding_enhance/list?mkey='+ encodeURIComponent(row_data.id) +'&session_id='+ encodeURIComponent(session_id) +'\'"';
		else
			html += 'disabled';
		html += '/>';

		return html;
	}

	function html_encode_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === '') ? data : escapeHTML(data);
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
		qlist.cr_del_url = '/delete?type=0';
		if(!list_can_view)
		{
			var mi_new = $('#mi_new_' + qlist.prefix);
			qmenu_enable_button(mi_new, false, qlist);
		}
	}

	function gen_qlist(datas){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		source = datas;

		var qlist_settings = {
			'prefix': 'base64rule_list',
			'source': datas,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'id'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': "#"},
				{'selector': 'url-pattern', 'lang_key': $j.getInfo("url_path",flt_lang)},
				{'selector': 'sz_field-list', 'lang_key': $j.getInfo("count",flt_lang)},
				{'selector': 'status', 'lang_key': $j.getInfo("status",flt_lang)},
			],
			'column_filters': {
				'enabled': false
			},
			'paging': {
				'enabled': false,
			},
			'options': {
				'ref_column': false,
				'sorting': false,
				'column_context_menu': false
			},
			'default_columns':['id', 'url-pattern', 'sz_field-list', 'status'],
			'search': { 'enabled': false },
			'format_fn': {
				'status': enable_format_fn,
				'url-pattern': html_encode_format_fn
			},
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#list_content");
		$container.qlist(qlist_settings);

	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom, _: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/waf/page_access/list?vdom="+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
