var module_list = (function($) {
	'use strict';

	var source;

	function setup_qlist()
	{
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id, vdom: vdom, _: new Date().getTime()},function(results) {
			if(results.status == 1) {
				source = results.datas;
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/system/ha_phlck/list?vdom=' + vdom);
			}
		});
	}

	function lang_format_fn(td, col, row_data){
                var data = row_data[col.selector];
                return (data === "") ? data : $j.getInfo(data);
        }

	function cert_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		var https = row_data['HTTPS'];
		return (https === 'enable') ? data : '';
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
		qlist.cr_del_url = '/delete?type=0';
	}

	function gen_qlist(){

		var qlist_settings = {
			'prefix': 'ha_phlck',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
			{name: 'mkey', selector: 'id'},
			{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
			{'selector': 'id', 'lang_key': '#'},
			{'selector': 'server-policy', 'lang_key': $j.getInfo("server_policy",flt_lang)},
			{'selector': 'HTTPS', 'lang_key': "HTTPS"},
			{'selector': 'client-cert', 'lang_key': $j.getInfo('client_cert', flt_lang)},
			{'selector': 'relationship', 'lang_key': $j.getInfo('relationship', flt_lang)},
			],
			'default_columns':['id', 'server-policy', 'HTTPS', 'client-cert', 'relationship'],
			'column_filters': {
				'enabled': false,
			},
			'callbacks': {
				'load': content_loaded
			},
			'format_fn': {
				'HTTPS': lang_format_fn,
				'relationship': lang_format_fn,
				'client-cert': cert_format_fn
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);
	}

	return {configure: setup_qlist};

})(jQuery);
