var module_list = (function($) {
	'use strict';

	var source;

	var	columns = [
			{'selector': 'id', 'lang_key': '#'},
			{'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
			{'selector': 'vip-list', 'lang_key': $j.getInfo('vip_list', flt_lang)},
			{'selector': 'node-order', 'lang_key': $j.getInfo("node_order",flt_lang)},
			];
	var default_columns = ['id','name', 'vip-list', 'node-order'];

	function setup_qlist()
	{
		$j.getJSON('/system/traffic_group_list/json', { _: new Date().getTime()},function(results) {
			if(results.status == 1) {
				source = results.datas;
				// if(multi_cluster_check){
				// 	var item1 = {'selector': 'node-order', 'lang_key': $j.getInfo('primary_node_order', flt_lang)};
				// 	var item2 = {'selector': 'secondary-node-order', 'lang_key': $j.getInfo('secondary_node_order', flt_lang)};
				// 	columns.splice(3,1,item1,item2);
				// 	default_columns.splice(3,1,'node-order','secondary-node-order');
				// }
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "system/ha_traffic_group/list?vdom="+vdom);
			}
		});
	}

	function order_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		var tooltip  = row_data[col.selector+"-tip"];
		var reg = /,$/gi;
		var reg_tip = new RegExp(",","g");
		var data = $j.trim(data);
	    var html = '';

	    data = data.replace(reg,'');
	    tooltip = tooltip.replace(reg,'');
		html = "<div><span  style='display:inline;' title='"+ tooltip+"'>"+ data+"</span></div>";
        return html;
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function gen_qlist(){

		var qlist_settings = {
			'prefix': 'ha_tg',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
			{name: 'mkey', selector: 'name'},
			{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': columns,
			'default_columns': default_columns,
			'column_filters': {
				'enabled': false,
			},
			'callbacks': {
				'load': content_loaded
			},
			'format_fn': {
				'node-order': order_format_fn,
				// 'secondary-node-order': order_format_fn,
				'vip-list': order_format_fn,
			}

		};

		var $container = $("#content");
		$container.qlist(qlist_settings);
	}

	return {configure: setup_qlist};

})(jQuery);
