var module_list = (function($) {
    'use strict';

    function content_loaded(qlist) {
        qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
    }
    function view_click(q)
    {
        var aElems = q.get_checked_rows();
        if (aElems.length != 1) return;

        var mkey = aElems[0].getAttribute("mkey");
        window.location.href = "/system/replacemsg/tablelayout?mkey=" + mkey + "&vdom=" + vdom; 
    }

    function clone_click(qlist, elems)
    {
        var clone_url = '/system/replacemsg/dlgcopy';
        var mkey = qlist_get_row_attr(elems, 'mkey');
        if(mkey){
            clone_url += '?mkey=' + encodeURIComponent(mkey);
            if(vdom) clone_url += '&vdom=' + encodeURIComponent(vdom);
            window.location.href = clone_url;   
        }
    }
    function rmsg_handle_selection_change(q)
    {
        qlist_handle_selection_change(q);

        var aElems = q.get_mixed_checked_rows();
        if(!is_rw_admin)
        {
            qmenu_enable_button($("#mi_view_" + q.prefix), true, q);
            return;
        }

        if(aElems.length == 1 && parseInt(aElems[0].getAttribute("can_clone")) == 1)
            qmenu_enable_button($("#mi_clone_" + q.prefix), true, q);
        else
            qmenu_enable_button($("#mi_clone_" + q.prefix), false, q);

        if (aElems.length == 1 && parseInt(aElems[0].getAttribute("can_v")) == 1)
        {
            qmenu_enable_button($("#mi_view_" + q.prefix), true, q);
            qmenu_enable_button($("#mi_edit_" + q.prefix), false, q);
        }else{
            qmenu_enable_button($("#mi_view_" + q.prefix), false, q);
        }
    }    
    function gen_qlist(datas) {
        var menu_items = [];
        if(is_rw_admin)
        {
            menu_items = {
                'mi_view': {
                    'id': 'mi_view',
                    'class': 'tool_sprite tool_view',
                    'handler': view_click,
                    'label': qed_strtbl.view
                },
                'mi_clone': {
                    'id': 'mi_clone',
                    'class': 'tool_sprite tool_clone',
                    'handler': clone_click,
                    'label': qed_strtbl.clone
                }
            };
        }
        var settings = {
            'prefix': 'replacemsg',
            'source': datas,
            'cr_new_url': create_url,
            'cr_edit_url': edit_url,
            'columns': [
                {'selector': 'id', 'lang_key': '#'},
                {'selector': 'name', 'lang_key': $j.getInfo('name', flt_lang) }
            ],
            'column_filters': {
                'enabled': false
            },
            'menu_items': menu_items,
            'options': {
                'ref_column': false,
                'sorting': false
            },
            'default_columns':['id', 'name'],
            'row_attr': [
                { name: 'mkey', selector: 'name' },
                { name: 'q_ref', selector: 'q_ref' },
                { name: 'can_clone', selector: 'can_clone'},
                { name: 'can_v', selector: 'can_view'}
            ],
            'handle_selection_change': rmsg_handle_selection_change,
            'callbacks': {
                'load': content_loaded
            }
        };

        var $container = $("#content");
        $container.qlist(settings);
    }

    function configure() {
        $j.getJSON('/cli-direct-action', { table_gid: g_cmdb_table_id, vdom:vdom, _: new Date().getTime() }, function(results) {
            if (results.status == 1) {
                gen_qlist(results.datas);
            } else {
                error_handler(results.msg_id, "/system/replacemsg/list");
            }
        });
    }

    return { configure: configure };

})(jQuery);
