var module_list = (function($) {
	'use strict';

	function type_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		if(data == 'ip')
			return $j.getInfo('type_ip', flt_lang);
		else if(data == 'pool')
			return $j.getInfo('type_pool', flt_lang);
		return '';
	}

	function ip_and_range_format_fn(td, col, row_data)
	{
		var type = row_data['trans-to-type'];
		if(type == 'ip')
			return row_data['trans-to-ip'];
		else if(type == 'pool')
			return row_data['trans-to-ip-start'] + ' - ' + row_data['trans-to-ip-end'];
		return '';
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;

		var th_len = $('table thead tr th').length;

		$('table tbody tr').first().before(
			"<tr id=\"tr_ip_forward\" style=\"background-color: #FFD710\" valign=\"middle\"><td colspan=\""+th_len+"\">"
			+"<img id=\"wij_modal_close_btn_fixed\" src=\"/images/x_small.gif\" style=\"right: 4px; position: fixed; cursor: pointer; \""
			+" onclick=\"document.getElementById('tr_ip_forward').style.display='none';\">"
			+$j.getInfo("need_ip_forward", fgt_lang)+"</td></tr>");
	}

	function gen_qlist(datas){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'mi_insert': {
					'id': 'mi_insert',
					'class': 'tool_sprite tool_insert',
					'handler': insert_click,
					'label': qed_strtbl.insert
				},
				'mi_move': {
					'id': 'mi_move',
					'class': 'tool_sprite tool_move',
					'handler': move_click,
					'label': qed_strtbl.move
				}
			};
		}
		var settings = {
			'prefix': 'sys_snat_policy_list',
			'source': datas,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'menu_items': menu_items,
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name',flt_lang)},
				{'selector': 'from', 'lang_key': $j.getInfo('from',flt_lang)},
				{'selector': 'to', 'lang_key': $j.getInfo('to',flt_lang)},
				{'selector': 'out-interface', 'lang_key': $j.getInfo('interface',flt_lang)},
				{'selector': 'trans-to-type', 'lang_key': $j.getInfo('type',flt_lang)},
				{'selector': 'trans-to-ip', 'lang_key': $j.getInfo('trans_ip',flt_lang)},
			],
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'column_filters': {
				'enabled': false
			},
			'handle_selection_change': selection_changed,
			'paging': {
				'enabled': false,
			},
			'options': {
				'ref_column': false,
				'sorting': false,
			},
			'default_columns':['id','name', 'from', 'to', 'out-interface', 'trans-to-type', 'trans-to-ip'],
			'format_fn': {
				'trans-to-type': type_format_fn,
				'trans-to-ip': ip_and_range_format_fn
			},
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");

		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id, _: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/system/snat_policy/list");
			}
		});
	}

	return {configure: configure};

})(jQuery);
