var module_list = (function($) {
	'use strict';

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function gen_qlist(datas) {		
		var settings = {
			'prefix': 'sys_vip_list',
			'source': datas,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name', flt_lang)},
				{'selector': 'vip', 'lang_key': $j.getInfo('ip', flt_lang)},
				{'selector': 'vip6', 'lang_key': $j.getInfo('vip6', flt_lang)},
				{'selector': 'interface', 'lang_key': $j.getInfo('interface', flt_lang)}
			],
			'column_filters': {
				'enabled': false
			},
			'default_columns':['id', 'name', 'vip', 'vip6', 'interface'],
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,_: new Date().getTime()}, function(results) {
			if (results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/system/network/vip/list");
			}
		});
	}

	return {configure: configure};

})(jQuery);
