var interface_list = (function($) {
    'use strict';

    var intf_details = {};

    var INTF_T_PHYSICAL = 0,
        INTF_T_VLAN = 1,
        INTF_T_AGG_8023AD = 2,
        INTF_T_AGG_BACKUP = 3;
    var source , ssid;
    var urls = {
        'newurl': '/system/network/intfvlandlg',
        'edit': {
            'dlg': '/system/network/intfdlg',
            'vlandlg': '/system/network/intfvlandlg',
            'bondingdlg': '/system/network/intfbondingdlg'
        },
        'change' : '/system/network/intfchange',
        'del' : '/delete'
    };

    function get_name(entry) {
        return entry.name;
    }

    function exists(cls) { return cls != null }
        
    function expand_format_fn(td, col, row_data) {
        var i, next_sibling, html, siblings_index;
        var last_level1_sibling_index;
        var parent = row_data.parent;
        var has_children = row_data.children && row_data.children.length;
        var siblings = parent ? row_data.parent.children : [];
        var indent = row_data.indent;
        var expand_larger = false;

        function get_base_level1_icon() {
            var base, last_level1, last_sibling, level1_ended;
            var value = '';
            if (has_children) {
                base = 'parent';
            } else if (parent) {
                last_level1 = siblings_index === last_level1_sibling_index;
                last_sibling = siblings_index === siblings.length - 1;
                level1_ended = siblings_index > last_level1_sibling_index;
                if (last_sibling && indent) {
                    base = 'child_last_indent';
                } else if (last_level1 || (last_sibling && !level1_ended)) {
                    base = 'child_last';
                } else {
                    base = level1_ended ? '' : 'child';
                }
            }
            if (base) {
                value =  '<div class="expansion_base_' + base + '"></div>';
            }
            return value;
        }

        function get_base_level2_icon() {
            var base;
            var value = '';
            var last_sibling = siblings_index === siblings.length - 1;
            if (last_sibling && indent) {
                base = '';
            } else if (next_sibling.indent) {
                base = indent ? 'child_indent' : 'sub_parent';
            } else if (indent) {
                base = 'child_last_indent';
            }
            if (base) {
                value = '<div class="expansion_base_' + base + '"></div>';
                expand_larger = true;
            }
            return value;
        }

        function get_expansion_icon() {
            var value = '';
	    var expansion = has_children ? 'expansion_parent' :
		    parent ?  'expansion_child' : '';
	    var expandBtn = '<button type="button" class="compact-visual-toggle"></button>';
            if (indent) {
                expansion += ' expansion_indent';
            }
            if (expansion) {
                value =  '<div class="expansion ' + expansion + '">';
		if(has_children)
			value += expandBtn;
		value += '</div>'; 
            }
            return value;
        }

        // Get our index in list of siblings as well as the index to the last
        // level 1 sibling
        for (i = 0; i < siblings.length; i++) {
            if (siblings[i].name === row_data.name) {
                siblings_index = i;
            }
            if (!siblings[i].indent) {
                last_level1_sibling_index = i;
            }
        }

        // Reference to next sibling
        if (typeof siblings_index === 'number' &&
            siblings_index + 1 < siblings.length) {
            next_sibling = siblings[siblings_index + 1];
        } else {
            next_sibling = {};
        }

        html = '<div class="expansion_container">';
        html += get_base_level1_icon();
        html += get_base_level2_icon();
        html += get_expansion_icon();

        td.css('min-width', '20px');
        if (expand_larger) {
            td.css('width', '30px');
        }
        return html + '</div>';
    }

    function child_sort(source_json) {
        /**
        * @return {interface[]} Array of all copies of the interface.
        */
        function intf_all_copies() {
            /* jshint validthis: true */
            var original = this.original || this;
            return [original].concat(original.copies || []);
        }
        /**
        * perform an action on all copies of an interface
        * @param {function(interface, index)} fn Callback for each copy.
        */
        function intf_each_copy(fn) {
            /* jshint validthis: true */
            $(this.all_copies())
                .each(function(i, intf) {
                    fn.call(this, intf, i);
                });
        }

        function index_intf(children, exclusive_member_map) {
            return function do_index(index, intf) {
                if (typeof intf !== 'string' && !(intf.name in index)) {
                    index[intf.name] = intf;
                }
                if (intf.children && intf.children.length) {
                    intf.children.reduce(do_index, index);
                }
                if (intf.parent) {
                    children.push(intf);
                }
                return index;
            };
            function add_to_exclusive_map(child) {
                exclusive_member_map[child] = true;
            }
        }

        function attach(intf) {
            intf.each_copy = intf_each_copy;
            intf.all_copies = intf_all_copies;
            return intf;
        }

        /*function update_partial_intf(intf) {
            var d_refs = 0;
            intf.can_delete = +(intf.q_ref - d_refs === 0);
            if (!('q_type' in intf)) {
                intf.q_type = 0;
            }
        }*/

        function index_children(source) {
            var result = {};
            for (var i = 0, len = source.length; i < len; ++i) {
                var parent = source[i],
                    children = parent.children;
                for (var c = 0, clen = children.length; c < clen; ++c) {
                    var child = children[c];
                    child.parent_intf = parent;
                    result[child.name] = child;
                }
            }
            return result;
        }
        function push_children(children, parent, new_children, result, indent) {
            if (children && children.length) {
                indent = indent || 1;
                for (var i = 0, len = children.length; i < len; ++i) {
                    children[i].parent = parent;
                    children[i].indent = indent;
                    children[i]._category = parent._category;
                    attach(children[i]);
                    //update_partial_intf(children[i]);
                    result.push(children[i]);
                    if (!(children[i].name in index)) {
                        index[children[i].name] = children[i];
                    }
                    new_children.push(children[i]);
                    push_children(children[i].children, parent, result,
                                  indent + 1);
                }
            }
        }
        var source = source_json;

        var name_ex = /^([^0-9]+)([0-9]+)$/,
            name_ex_exec = name_ex.exec.bind(name_ex);
        function intf_sort(a, b) {
            
            var name_parts = [a, b].map(get_name).map(name_ex_exec);
            //hybrid name compare eg: port10 > port2
            if (name_parts.every(exists) && name_parts.reduce(names_match)) {
                return name_parts.reduce(compare_nums);
            }
            return a.name > b.name ? 1 :
                (b.name > a.name ? -1 : 0);

            function names_match(a, b) { return a[1] === b[1] }
            function compare_nums(a, b) { return Number(a[2]) - Number(b[2]) }
        }
        var index = {},
            i, child, parent, len = source.length,
            result = [], intf, intf_children,
            children = [], exclusive_member_map = {},

            type_categories = { 0: 'physical', 2: 'aggregate', 3: 'redundant'};
        source.sort(intf_sort);

        source.reduce(index_intf(children, exclusive_member_map), index);
        for (i = 0, len = children.length; i < len; ++i) {
            child = children[i];
            parent = index[child.parent];
            //vlans are not in the main level of index
            //but tunnels can have vlans as parents
            if (!parent || parent.children == null) {
                var child_index = child_index || index_children(source);
                parent = child_index[child.parent];
                if (parent) {
                    var found = parent.parent_intf.children.indexOf(parent);
                    child.indent = 1;
                    parent.parent_intf.children.splice(found + 1, 0, child);
                } else {
                    //Crazy config where hidden loopback has vlans and tunnels?
                    //Promote orphaned interface to top level.
                    source.push(child);
                }
            } else {
                parent.children.push(child);
                if (child.children && child.children.length) {
                    Array.prototype.splice
                         .apply(parent.children, [0, 0].concat(child.children));
                }
            }
        }

        // tracking children which may hide from top list
        children = [];

        for (i = 0, len = source.length; i < len; ++i) {
            intf = source[i];
            attach(intf);

            result.push(intf);
            intf_children = [];
                
            intf._category = $.getInfo(type_categories[intf.type] || intf.type,flt_lang);

            intf.children.forEach(process_child_intf);
            intf.children = intf_children;
        }
        function process_child_intf(child_intf) {
            //intf set in loop above
            var orig_intf = child_intf;
            if (typeof child_intf === 'string') {
                //default ssl.* intf can be in a zone,
                //but not show in the json list
                child_intf = index[child_intf] ||
                    attach({name: child_intf, q_ref: 0});
                orig_intf = child_intf;
            } else {
                index[child_intf.name] = child_intf;
                attach(child_intf);
                //update_partial_intf(child_intf);
            }
            /* push this child to source list as expansion of intf */
            // make an entry copy
            child_intf.copies = child_intf.copies || [];
            child_intf = $.extend({},
                                  child_intf,
                                  {original: child_intf});
            child_intf.original.copies.push(child_intf);
            child_intf.parent = intf;
            child_intf.parent_name = intf.name;
            child_intf._category = intf._category;
            if (child_intf.can_delete !== 1) {
                intf.can_delete = 0;
            }

            // Ensure VLAN is only listed once if it is also a member of
            // a zone or pair
            if (!exclusive_member_map[child_intf.name]) {
                result.push(child_intf);
                intf_children.push(child_intf);
                
                    push_children(child_intf.children, intf,
                        intf_children, result);
                
                child_intf.children = [];
            }
        }
        // ensure pure children get pulled into the zone.
        // Ref checks won't work with copies,
        // have to use explicit names comparisons
        // TODO: optimize to reduce O(NxM) and remove names comparisons
        var children_name = $.map(children,
            function(item) { return item.name; });
        $(children).each(function(i, child) {
            if (!child.each_copy) {
                attach(child);
            }
            child.each_copy(function(copy) {
                // only original(top) interface will be examined
                if (copy.original === undefined) {
                    if (copy.children && copy.children.length) {
                        for (var j = 0; j < copy.children.length; ++j) {
                            var grandchild = copy.children[j].name;
                            if (children_name.indexOf(grandchild) === -1) {
                                copy.can_view = 0;
                                return;
                            }
                        }
                    }
                    copy.hide = true;
                    if (copy.parent && copy.parent.children) {
                        copy.parent.children = copy.parent.children
                            .filter(function(pchild) {
                                return pchild !== copy;
                            });
                    }
                }
            });
        });
        result = result.filter(function(intf) {
            return !intf.hide;
        });
       
        intf_details = index;
        return result;
    }

    function setup_expansion_trees() {
        /* jshint validthis: true */
        var $expansion_parents = $(this).find('.expansion.expansion_parent');

        // Expand/hide the hidden/hideable rows associated with the current row
        //  Leave 'expand' undefined to toggle the value, or set to True to expand, False to hide
        function expand_row($row_to_expand, expand) {
            $row_to_expand.nextUntil(':not(.intf_expansion)').andSelf()
                .toggleClass('intf_expanded', expand);
        }

        // Retrieve list of which rows are expanded from persistent storage
        var expand_states = fweb.util.persist.get('interface_list_expanded');
        if (expand_states) {
            // Expand all the rows that were expanded last time we were here
            $expansion_parents
                .each(function() {
                    // Set the expansion state for the row
                    var $this = $(this);
                    var $expansion_row = $this.closest('tr.qlist_row');
                    var mkey = $expansion_row.attr('mkey');
                    if ($.inArray(mkey, expand_states) !== -1) {
                        $this.find('.compact-visual-toggle').addClass('active');
                        expand_row($expansion_row, true);
                    }
                });
        }

        $('.compact-visual-toggle')
            .off('click').on('click', function(event) {
                var $this = $(this);
                var $expansion = $this.closest('tr.qlist_row');
                expand_row($expansion);
                $this.toggleClass('active');
                event.stopPropagation();

                // Store the expanded state of this row
                var expand_states = fweb.util.persist.get('interface_list_expanded') || [];
                var mkey = $expansion.attr('mkey');
                var mkey_index = expand_states.indexOf(mkey);
                var expanded = $this.hasClass('active');

                if (expanded) {
                    // Ensure the mkey isn't somehow stored twice
                    //  (shouldn't be able happen, but better to be safe)
                    if (mkey_index === -1) {
                        expand_states.push(mkey);
                    }
                } else {
                    // If not there, don't try to remove it
                    if (mkey_index !== -1) {
                        expand_states.splice(mkey_index, 1);
                    }
                }

                fweb.util.persist.put('interface_list_expanded', expand_states);
            }).on('dblclick', function(event) {
                event.stopPropagation();
            });
    }

    function link_status_format_fn(td, col, row_data){
        var status = row_data.link_status;
        var html = '';
        var tooltip;
        if(status == "up")
        {
            tooltip = "<span style='display:inline;' title = '"+$j.getInfo("lup",flt_lang)+"' class='tool_sprite tool_up'></span>";
        }
        else if(status == "down")
        {
            tooltip = "<span style='display:inline;' title = '"+$j.getInfo("ldown",flt_lang)+"' class='tool_sprite tool_down_grey'></span>";
        }

        html = "<div>"+tooltip+"</div>";

        return html;

    }

    function type_format_fn(td, col, row_data){
        var type = row_data.type;
        var members  = row_data.members;
        var typeName = '';
        var extra = '';
        var type_label;
        if(members)
        {
            var a = members.split(',');
            extra = '<span class="add_qtip member_count" title="' + members + '>&nbsp;' +a.length+ ')</span>';
        }
        if(type == INTF_T_PHYSICAL)
        {
            typeName = "physical";
        }
        else if(type == INTF_T_VLAN)
        {
            typeName = "vlan";
        }
        else if(type == INTF_T_AGG_8023AD)
        {
            typeName = "aggregate";
        }
        else if(type == INTF_T_AGG_BACKUP)
        {
            typeName = "redundant";
        }
        type_label = $.getInfo(typeName,flt_lang);
	if(opmode == 1 && type == INTF_T_VLAN)
	{
		var proto = row_data.vlan_proto ? row_data.vlan_proto : 0;
		if(0 == proto)
			type_label += "(802.1Q)";
		else if(1 == proto)
			type_label += "(802.1ad)";
	}

        return '<span class="tool_sprite tool_' + typeName + ' ">' + type_label + extra + '</span>';
    }

    function access_format_fn($td, col, row_data)
    {
        var COLOR_MAP = {
            'telnet': 'red',
            'snmp': 'orange',
            'auto-ipsec': 'blue',
            'fgfm': 'blue',
            'radius-acct': 'blue',
            'forticlient_access': 'blue',
            'probe-response': 'blue',
            'capwap': 'blue'
        };
        var values = (row_data[col.selector] || '').split(',');
        var MAX_PER_LINE = 7;

        $td.addClass("left");

        return values.map(function(value, index){
            var color, html;
            var label = $j.getInfo(value,flt_lang);
            var lowerCaseValue = value.toLowerCase(); 
            label = (label === value) ? value.toUpperCase() : label;
            color = COLOR_MAP[lowerCaseValue] || 'grey';
            
            html = value ? '<span class="access access-' + color + '">' + value + '</span>' : '';
            
            if (index !== 0 && (index + 1) % MAX_PER_LINE === 0) {
                html += '<br/>';
            }
            return html;

        }).join('');

    }

    function status_format_fn($td, col, row_data)
    {
        var stus = row_data.status;
        var html = '';
        var tooltip = '';
        var change_url = urls.change;
        var change_status;
        var type = row_data.type;
        
        if(stus == "down")
        {
            change_url += "?status=1&mkey=" + row_data.name;
            change_status = 1;
            if(!is_rw_admin)
            {
                 tooltip = '<span class="tool_sprite tool_down"></span>';
            }
            else if(type == INTF_T_VLAN && row_data.parent_down == 1)
            {
                 tooltip = '<span class="tool_sprite tool_down">'+$.getInfo('bup',flt_lang)+'</span>';
            }
            else
            {
                 tooltip = '<span class="tool_sprite tool_down"><a href="javascript: bringDown(\''+change_url+'\', '+change_status+');">'+$.getInfo('bup',flt_lang)+'</a></span>';
            }
        }
        else if(stus == "up")
        {
            if(!is_rw_admin)
            {
                tooltip = '<span class="tool_sprite tool_up"></span>';
            }
            else
            {
                change_url += "?status=0&mkey=" + row_data.name;
                change_status = 0;
                tooltip = '<span class="tool_sprite tool_up"><a href="javascript: bringDown(\''+change_url+'\', '+change_status+');">'+$.getInfo('bdown',flt_lang)+'</a></span>';
            }
        }
        else
        {
            tooltip = '<span class="tool_sprite tool_up"><b>'+stus+'</b></span>';
        }
        html = "<div>"+tooltip+"</div>";

        return html;
    }

    function create_click(qlist, elems)
    {
        window.location.href = urls.newurl;
    }
    function edit_click(qlist, elems){
        var mkey = qlist_get_row_attr(elems, 'mkey'),
            type = qlist_get_row_attr(elems, 'type'),
            can_edit = Number(qlist_get_row_attr(elems, 'can_edit'));
        var url;
        if (mkey && Number(can_edit) !== 0) {
            var index;
            mkey = encodeURIComponent(mkey);
           
            if(type == INTF_T_PHYSICAL)
            {
                url = urls.edit.dlg;
            }
            else if(type == INTF_T_VLAN)
            {
                url = urls.edit.vlandlg;
            }
            else if(type == INTF_T_AGG_8023AD)
            {
                url = urls.edit.bondingdlg;
            }
            else if(type == INTF_T_AGG_BACKUP)
            {
                url = urls.edit.bondingdlg;
            }

            window.location.href = url + "?name=" + mkey;
        }
    }

    function delete_click(qlist, elems){
        var del_url = urls.del;
        var aElems = qlist.get_checked_rows();

        del_url += '?session_id=' + data.ssid;

        aElems.each(function() {
            del_url += '&mkey=' + qlist_get_row_attr(this, 'mkey');
        });
        window.location.href = del_url;
    }

    function status_up(qlist, elems) {
        var mkey = qlist_get_row_attr(elems, 'mkey'),
            change_url = urls.change;

        change_url += "?status=1&mkey=" + mkey;

        bringDown(change_url, 1);
    }

    function status_down(qlist, elems) {
        var mkey = qlist_get_row_attr(elems, 'mkey'),
            change_url = urls.change;

        change_url += "?status=0&mkey=" + mkey;

        bringDown(change_url, 0);
    }

    function row_gen_fn(rowIndex, row_data) {
        /* jshint validthis: true */
        if (row_data.parent) {
            this.addClass('intf_expansion');
        }
    }

    function selection_changed(qlist) {

            function flatten(results, arr) {
                    return results.concat(arr);
            }

            function port_name(intf) {
                    if (intf.type !== 'physical') {
                            intf.each_copy(function(copy) {
                                    if (copy.parent && copy.parent.type === 'physical') {
                                            intf = copy.parent;
                                    }
                            });
                            if (intf.members) {
                                    return intf.members;
                            }
                    }
                    return [intf.name];
            }

        // Let the default handler handle the standard buttons.

        var aElems = qlist.get_checked_rows();

        var can_delete = true;
        if(aElems.length < 1){
            can_delete = false;
        }
        aElems.each(function() {
            if(qlist_get_row_attr(this, 'ref') != 0 || 
                (qlist_get_row_attr(this, 'type') != INTF_T_VLAN && qlist_get_row_attr(this, 'type') != INTF_T_AGG_8023AD
                    && qlist_get_row_attr(this, 'type') != INTF_T_AGG_BACKUP)){
                can_delete &= false;
            }
        });
        
        qmenu_enable_button($("#mi_del_" + qlist.prefix), can_delete, qlist);

        if(aElems.length == 1){
            var elem = aElems[0];
            var status = qlist_get_row_attr(elem, 'status');
            var admin_up = (status == 'down');

            if(parseInt(qlist_get_row_attr(elem, 'can_edit'))) {
                qmenu_enable_button($("#mi_edit_" + qlist.prefix), true, qlist);
            }
            if(status == $.getInfo('used_by_ha_monitor',flt_lang) || status == $.getInfo('used_by_ha',flt_lang) || status == $.getInfo('used_by_bridge',flt_lang))
            {
                qmenu_enable_button($("#mi_admin_up_" + qlist.prefix), false, qlist);
                qmenu_enable_button($("#mi_admin_down_" + qlist.prefix), false, qlist);
            }else{
                qmenu_enable_button($("#mi_admin_up_" + qlist.prefix), admin_up, qlist);
                qmenu_enable_button($("#mi_admin_down_" + qlist.prefix), !admin_up, qlist);
            }           
            

        } else {
            qmenu_enable_button($("#mi_edit_" + qlist.prefix), false, qlist);
            qmenu_enable_button($("#mi_admin_up_" + qlist.prefix), false, qlist);
            qmenu_enable_button($("#mi_admin_down_" + qlist.prefix), false, qlist);
        }

        var selection = aElems.map(function(i, elem) {
                var ret = data.results;
                for(var j = 0; j < ret.length; j++)
                {
                        if(elem.getAttribute('mkey') == ret[j].name)
                                return ret[j];

                        for(var k = 0; k < ret[j].children.length; k++)
                        {
                                if(elem.getAttribute('mkey') == ret[j].children[k].name)
                                        return ret[j];
                        }
                }
        }).toArray();

        var expansion = aElems.hasClass('intf_expansion') ? [] :
                aElems.nextUntil(':not(.intf_expansion)')
                .map(function(i, elem) {
                        var ret = data.results;
                        for(var j = 0; j < ret.length; j++)
                        {
                                if(elem.getAttribute('mkey') == ret[j].name)
                                        return ret[j];
                        }
                }).toArray();

        var selected_names = selection.concat(expansion)
                .map(port_name).reduce(flatten, []);

        $('#fwb').find('[port_id],[group_name]').each(function() {
                var port_id = this.getAttribute('port_id'),
                group_name = this.getAttribute('group_name');
                var highlight = false;
                if(selected_names)
                        highlight = selected_names.indexOf(port_id) > -1 || 
                        selected_names.indexOf(group_name) > -1;
                $(this).toggleClass('selected', highlight);
        });
    }

    function content_loaded(qlist) {
        qmenu_display_button('#mi_new_' + qlist.prefix, create_new);
	qmenu_display_button('#mi_admin_up_' + qlist.prefix, false);
        qmenu_display_button('#mi_admin_down_' + qlist.prefix, false);
        setup_expansion_trees.call(this);
        qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
    }

    function gen_qlist(){
        if (!window.fgt_lang || !fgt_lang["global"])
            $j.addLang();
        source = data.results,
        session_id = data.ssid;
        var menu_items;
        if(is_rw_admin){
		if(create_new)
		{
		    menu_items = {
		        'create_new': {
		            'handler':create_click
		        },
		        'edit': {
		            'handler': edit_click
		            
		        },
		        'delete': {
		            'class': 'tool_sprite tool_delete'
		        },
		        'mi_admin_up': {
		            'label': $.getInfo('bup',flt_lang),
		            'handler': status_up,
		            'class': 'tool_sprite tool_up'
		        },
		        'mi_admin_down': {
		            'label': $.getInfo('bdown',flt_lang),
		            'handler': status_down,
		            'class': 'tool_sprite tool_down_grey'
		        }
		    };
		}else{
		    menu_items = {
		        'edit': {
		            'handler': edit_click
		            
		        },
		        'delete': {
		            'class': 'tool_sprite tool_delete'
		        },
		        'mi_admin_up': {
		            'label': $.getInfo('bup',flt_lang),
		            'handler': status_up,
		            'class': 'tool_sprite tool_up'
		        },
		        'mi_admin_down': {
		            'label': $.getInfo('bdown',flt_lang),
		            'handler': status_down,
		            'class': 'tool_sprite tool_down_grey'
		        }
		    };
		}
        } else {
            menu_items = {
                'edit': {
                    'handler': edit_click
                }
            }
        }

        var qlist_settings = {
            'prefix': 'sysnetintf',
            'source': child_sort(source),
            'row_attr': [
                    {name: 'mkey', selector: 'name'},
                    {name: 'can_edit', selector: 'can_edit'},
                    {name: 'type', selector: 'type'},
                    {name: 'ref', selector: 'ref'},
                    {name: 'status', selector: 'status'}
                ],
            'categories': ['_category'],
            'columns': [
                {'selector': '__pseudo_expand', 'lang_key': ' ', 'fixed': true,
                    'class': '__pseudo'
                },
                {'selector': 'name', 'lang_key': "name"},
                {'selector': 'members', 'lang_key': "members"},
                {'selector': 'type', 'lang_key': "field_type"},
                {'selector': 'ip', 'lang_key': "ip"},
                {'selector': 'allowaccess', 'lang_key': "access"},
                {'selector': 'ip6', 'lang_key': "ip6"},
                {'selector': 'ip6-allowaccess', 'lang_key': "ip6access"},
                {'selector': 'status', 'lang_key': "link"},
                {'selector': 'link_status', 'lang_key': "field_link"},
                {'selector': 'ref', 'lang_key': "ref"}
            ],
            'menu_items': menu_items,
            'default_columns':['__pseudo_expand', 'name', 'members', 'ip', 'allowaccess', 'status', 'link_status', 'type', 'ref'],
            'column_filters': {
                'enabled': true,
                'exempts': ['__pseudo_expand','members','type','allowaccess','ip6-allowaccess','status','link_status','ref']
            },
            'options':{
                'fixed_header': true,
                'row_striping': false,
                'resize_to_parent': true,
                'collapsible_categories': {'*': false},
                'resizable_columns': false
            },
            'format_fn': {
                    '__pseudo_expand': expand_format_fn,
                    'type' : type_format_fn,
                    'allowaccess': access_format_fn,
                    'ip6-allowaccess': access_format_fn,
                    'status' : status_format_fn,
                    'link_status': link_status_format_fn
            },
            'handle_selection_change': selection_changed,
            'row_gen': row_gen_fn,
            'callbacks': {
                'load': content_loaded
            }
        };

        var $container = $("#content");
        $container.qlist(qlist_settings);
    }

    return {configure: gen_qlist};

})(jQuery);
