var module_list = (function($) {
	'use strict';

	var source;

	function sniffer_find_id(obj) {
        return $(obj).parents(".qlist_row").attr("mkey")
    }

	function content_loaded(qlist) 
	{
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
		qlist.cr_del_url = '/delete?type=0';

		/* start 0, stop 1, restart 2 */
		$(".qlist").delegate(".fa-play", "click", function() {
            SnifferCommon.sniffer_action(sniffer_find_id(this), "0")
        }),
        $(".qlist").delegate(".fa-stop", "click", function() {
            SnifferCommon.sniffer_action(sniffer_find_id(this), "1")
        }),
        $(".qlist").delegate(".fa-repeat", "click", function() {
            SnifferCommon.sniffer_action(sniffer_find_id(this), "2")
        }),
        $(".qlist").delegate(".fa-download", "click", function() {
            SnifferCommon.sniffer_download(sniffer_find_id(this))
        }),
        SnifferCommon.sniffer_progress_init()
	}

	function setup_qlist()
	{
		$j.getJSON('/system/network/packet_capture/list/json', {table_gid:g_cmdb_table_id, _: new Date().getTime()},function(results) {
			if(results.status == 1) {
				source = results.datas;
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/system/network/packet_capture/list');
			}
		});
	}

	function filter_format_fn(td, col, row_data){
		var html;
		html = row_data.host
		return row_data.port;	
	}
	function downloadfile(qlist, elems)
	{
		var mkey = qlist_get_row_attr(elems, 'mkey');
		var path = "/downloadfile?msg=34&name=";
		
		if(mkey){
			path = setQueryValue(path, 'name', mkey);
			path = setQueryValue(path, 'session_id', session_id);
			window.location.href = path;
		}
	}
	function delfile(qlist, elems)
	{
		if (!confirm($.getInfo('del_file_confirm'))) {
	        return;
	    }
		$j.getJSON('/system/network/packet_capture/list/json', {action:'3', _: new Date().getTime()},function(results) {
			if(results.status == 1) {
				source = results.datas;
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/system/network/packet_capture/list');
			}
		});		

	}
	function handle_selection_change(q)
	{
		// Let the default handler handle the standard buttons.
		qlist_handle_selection_change(q);

		var aElems = q.get_checked_rows();
		var mi_download = $("#mi_download_" + q.prefix);
		qmenu_enable_button(mi_download, false, q);
		if(aElems.length == 1 && is_rw_admin && aElems[0].getAttribute('can_down') == 0)
		{
			qmenu_enable_button(mi_download, true, q);
		}
	}
	function gen_qlist(){
		var menu_items = {};
		if(is_rw_admin){
			menu_items = {
				/*
				'mi_download': {
					'id': 'mi_download',
					'label': $.getInfo('download'),
					'class': 'tool_download',
					'handler': downloadfile,
				},*/
				'mi_del_file': {
					'id': 'mi_del',
					'label': $.getInfo('mi_del_file'),
					'class': 'tool_delete',
					'handler': delfile,
				}
			};
		}

		var qlist_settings = {
			'prefix': 'packet_capture',
			'source': source,
			'handle_selection_change': handle_selection_change,
			'menu_items': menu_items,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'id'},
				{name: 'q_ref', selector: 'q_ref'},
				{name: 'can_down', selector: 'can_down'},
			],
			'columns': [
			{'selector': 'id', 'lang_key': '#'},
			{'selector': 'interface', 'lang_key': $j.getInfo("interface")},
			{'selector': 'packets', 'lang_key': $j.getInfo("packets")},
			{'selector': 'filter_captutre', 'lang_key': $j.getInfo("filter")},
			{'selector': 'max_packets', 'lang_key': $j.getInfo('max_packets')},
			{'selector': 'progress', 'lang_key': $j.getInfo('progress')}
			],
			'default_columns':['id', 'interface', 'filter_captutre', 'packets', 'max_packets', 'progress'],
			'column_filters': {
				'enabled': true,
				'exempts': ['id', 'packets', 'progress']
			},
            'format_fn': {
				'filter_captutre' : filter_format_fn,
				'packets': function(td, col, entry) {
                    return '<span id="sniffer_packets_' + entry.id + '" />'
                },
                'progress': function(td, col, entry) {
                    return '<div id="sniffer_progress_' + entry.id + '" /><span id="sniffer_state_' + entry.id + '" />'
                }
            },
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);
	}

	return {configure: setup_qlist};

})(jQuery);
