var module_list = (function($) {
	'use strict';
	
	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}
	
	function lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data, flt_lang);
	}
	
	function gen_qlist(datas) {
		var settings = {
			'prefix': 'traffic_bot',
			'source': datas,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name', flt_lang)},
				{'selector': 'bot-recognition', 'lang_key': $j.getInfo('for_browser', flt_lang)},
				{'selector': 'mobile-app-identification', 'lang_key': $j.getInfo('for_mobile_app', flt_lang)},
				{'selector': 'bot-confirmation', 'lang_key': $j.getInfo('bot_confirmation', flt_lang)},

				//crawler
				{'selector': 'crawler-detection', 'lang_key': $j.getInfo('crawler_detection', flt_lang)},
				{'selector': 'crawler-action', 'lang_key': $j.getInfo('crawler_action', flt_lang)},
				{'selector': 'crawler-severity', 'lang_key': $j.getInfo('crawler_severity', flt_lang)},
				{'selector': 'crawler-trigger', 'lang_key': $j.getInfo('crawler_trigger', flt_lang)},
				{'selector': 'crawler-occurrence-num', 'lang_key': $j.getInfo('crawler_occurrence_num', flt_lang)},
				{'selector': 'crawler-within', 'lang_key': $j.getInfo('crawler_within', flt_lang)},
				{'selector': 'crawler-block-period', 'lang_key': $j.getInfo('crawler_block_period', flt_lang)},
				//scanner
				{'selector': 'scanner-detection', 'lang_key': $j.getInfo('scanner_detection', flt_lang)},
				{'selector': 'scanner-action', 'lang_key': $j.getInfo('scanner_action', flt_lang)},
				{'selector': 'scanner-severity', 'lang_key': $j.getInfo('scanner_severity', flt_lang)},
				{'selector': 'scanner-trigger', 'lang_key': $j.getInfo('scanner_trigger', flt_lang)},
				{'selector': 'scanner-occurrence-num', 'lang_key': $j.getInfo('scanner_occurrence_num', flt_lang)},
				{'selector': 'scanner-within', 'lang_key': $j.getInfo('scanner_within', flt_lang)},
				{'selector': 'scanner-block-period', 'lang_key': $j.getInfo('scanner_block_period', flt_lang)},
				//slow-attack
				{'selector': 'slow-attack-detection', 'lang_key': $j.getInfo('slow_attack_detection', flt_lang)},
				{'selector': 'slow-attack-action', 'lang_key': $j.getInfo('slow_attack_action', flt_lang)},
				{'selector': 'slow-attack-severity', 'lang_key': $j.getInfo('slow_attack_severity', flt_lang)},
				{'selector': 'slow-attack-trigger', 'lang_key': $j.getInfo('slow_attack_trigger', flt_lang)},
				{'selector': 'slow-attack-occurrence-num', 'lang_key': $j.getInfo('slow_attack_occurrence_num', flt_lang)},
				{'selector': 'slow-attack-within', 'lang_key': $j.getInfo('slow_attack_within', flt_lang)},
				{'selector': 'slow-attack-http-transaction-timeout', 'lang_key': $j.getInfo('slow_attack_http_timeout', flt_lang)},
				{'selector': 'slow-attack-packet-interval-timeout', 'lang_key': $j.getInfo('slow_attack_packet_timeout', flt_lang)},
				{'selector': 'slow-attack-block-period', 'lang_key': $j.getInfo('slow_attack_block_period', flt_lang)},
				//content
				{'selector': 'content-scraping-detection', 'lang_key': $j.getInfo('content_scraping_detection', flt_lang)},
				{'selector': 'content-scraping-action', 'lang_key': $j.getInfo('content_scraping_action', flt_lang)},
				{'selector': 'content-scraping-severity', 'lang_key': $j.getInfo('content_scraping_severity', flt_lang)},
				{'selector': 'content-scraping-trigger', 'lang_key': $j.getInfo('content_scraping_trigger', flt_lang)},
				{'selector': 'content-scraping-occurrence-num', 'lang_key': $j.getInfo('content_scraping_occurrence_num', flt_lang)},
				{'selector': 'content-scraping-within', 'lang_key': $j.getInfo('content_scraping_within', flt_lang)},
				{'selector': 'content-scraping-block-period', 'lang_key': $j.getInfo('content_scraping_block_period', flt_lang)},
				//brute-login
				{'selector': 'brute-login-detection', 'lang_key': $j.getInfo('brute_login_detection', flt_lang)},
				{'selector': 'brute-login-action', 'lang_key': $j.getInfo('brute_login_action', flt_lang)},
				{'selector': 'brute-login-severity', 'lang_key': $j.getInfo('brute_login_severity', flt_lang)},
				{'selector': 'brute-login-trigger', 'lang_key': $j.getInfo('brute_login_trigger', flt_lang)},
				{'selector': 'brute-login-occurrence-num', 'lang_key': $j.getInfo('brute_login_occurrence_num', flt_lang)},
				{'selector': 'brute-login-within', 'lang_key': $j.getInfo('brute_login_within', flt_lang)},
				{'selector': 'brute-login-request-file', 'lang_key': $j.getInfo('brute_login_url', flt_lang)},
				{'selector': 'brute-login-block-period', 'lang_key': $j.getInfo('brute_login_block_period', flt_lang)},
			],
			'column_filters': {
				'enabled': false,
			},
			'paging': {
				'enabled': false,
			},
			'options': {
				'ref_column': false,
				'sorting': false
			},
			'callbacks': {
				'load': content_loaded
			},
			'default_columns':['id', 'name','crawler-detection', 'scanner-detection', 'slow-attack-detection', 'content-scraping-detection', 'brute-login-detection'],
			'search': { 'enabled': false },
			'format_fn': {
				'bot-recognition': lang_format_fn,
				'crawler-detection': lang_format_fn,
				'scanner-detection': lang_format_fn,
				'slow-attack-detection': lang_format_fn,
				'content-scraping-detection': lang_format_fn,
				'brute-login-detection': lang_format_fn,
				'crawler-action': lang_format_fn,
				'scanner-action': lang_format_fn,
				'slow-attack-action': lang_format_fn,
				'content-scraping-action': lang_format_fn,
				'brute-login-action': lang_format_fn,
				'crawler-severity': lang_format_fn,
				'scanner-severity': lang_format_fn,
				'slow-attack-severity': lang_format_fn,
				'content-scraping-severity': lang_format_fn,
				'brute-login-severity': lang_format_fn,
				'mobile-app-identification': lang_format_fn,
				'bot-confirmation':lang_format_fn
			},
		};

		var $container = $("#content");

		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom,_: new Date().getTime()},function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/waf/traffic_bot/list?vdom='+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
