var module_list = (function($) {
	'use strict';

	var source;

	function type_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		var key = '';
		if(data == 'pre-defined')
			key = 'pre_defined';
		else if(data == 'custom-defined')
			key = 'custom_defined';
		return $j.getInfo(key, flt_lang);
	}

	function app_type_format_fn(td, col, row_data)
	{
		if(row_data.type == 'pre-defined'){
			var data = row_data[col.selector];
			var key = '';
			if(data == 'owa-2003')
				key = 'owa';
			else
				key = 'jsp';
			return $j.getInfo(key, flt_lang);
		}else{
			return '';
		}
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function gen_qlist(datas){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();

		source = datas;

		var qlist_settings = {
			'prefix': 'url_replacer',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
				{'selector': 'type', 'lang_key': $j.getInfo("type",flt_lang)},
				{'selector': 'app-type', 'lang_key': $j.getInfo("app_type", flt_lang)}
			],
			'default_columns':['id', 'name', 'type', 'app-type'],
			'column_filters': {
				'enabled': false
			},
			'options':{
				'ref_column': false,
				'sorting': false,
			},
			'callbacks': {
				'load': content_loaded
			},
			'format_fn': {
				'type': type_format_fn,
				'app-type': app_type_format_fn
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);

	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom, _: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/prot/url_replacer/list");
			}
		});
	}

	return {configure: configure};

})(jQuery);
