var module_list = (function($) {
	'use strict';

	var source;
	var action_lang = {
		'http-body-rewrite' : "re_body",
		'location-rewrite' : "location_rewrite",
		'403-forbidden' : "re_403",
		'http-header-rewrite' : "re_url",
		'redirect' : "re_redir",
		'redirect-301' : "re_redir_301"
	}

	function action_type_format_fn(td, col, row_data){
		var data = row_data["action"];
		if(data === 'http-body-rewrite' || data === 'location-rewrite')
			return $j.getInfo('response_action',flt_lang);
		else if(data === '403-forbidden' || data === 'http-header-rewrite' || 
			data === 'redirect' || data === 'redirect-301')
			return $j.getInfo('request_action',flt_lang);
		else
			return '';
	}

	function action_format_fn(td, col, row_data){
		var data = row_data['action'];
		var lang = action_lang[data] ? action_lang[data] : '';
		return (lang === '') ? lang : $j.getInfo(lang,flt_lang);
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function gen_qlist(datas){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		source = datas;

		var qlist_settings = {
			'prefix': 'url_rewrite_rule',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
			{name: 'mkey', selector: 'name'},
			{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
			{'selector': 'id', 'lang_key': '#'},
			{'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
			{'selector': 'action_type', 'lang_key': $j.getInfo("action_type",flt_lang)},
			{'selector': 'action', 'lang_key': $j.getInfo("action",flt_lang)},
			{'selector': 'sz_match-condition', 'lang_key': $j.getInfo("count",flt_lang)}
			],
			'default_columns':['id', 'name', 'action_type', 'action', 'sz_match-condition'],
			'column_filters': {
				'enabled': false
			},
			'options':{
				'ref_column': false,
				'sorting': false,
			},
			'callbacks': {
				'load': content_loaded
			},
			'format_fn': {
				'action_type': action_type_format_fn,
				'action': action_format_fn
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);

	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom,_: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/waf/url_rewrite_rule/list?vdom="+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
