var module_list = (function($) {
	'use strict';
	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function enable_format_fn(td, col, row_data){

		var status = row_data.status;
		var html = '<input type="checkbox" class="toggle-switch" name="kdc_enable' + row_data['id'] + '" id="kdc_enable' + row_data['id'] + '" '+ (status == 'enable'? 'checked ' : '');
		if(is_rw_admin)
			html += 'onclick="window.location=\'/user/kdc_user/list?mkey='+ encodeURIComponent(row_data.name) +'&session_id='+ encodeURIComponent(session_id) +'\'"';
		else
			html += 'disabled';
		html += '/><label for="kdc_enable' + row_data['id'] + '"></label>';

		return html;
	}

	function status_format_fn(td, col, row_data){
		var status = row_data.status;

		if(status == 'enable')
			return '<f-icon class="fa-link" title="'+ $j.getInfo('run',flt_lang) +'"></f-icon>';
		else
			return '<f-icon class="fa-chain-broken" title="'+ $j.getInfo('idle',flt_lang) +'"></f-icon>';
	}

	function gen_qlist(datas){		
		var settings = {
			'prefix': 'user_kdc_list',
			'source': datas,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name',flt_lang)},
				{'selector': 'realm', 'lang_key': $j.getInfo('delegated_realm',flt_lang)},
				{'selector': 'shortname', 'lang_key': $j.getInfo('shortname',flt_lang)},
				{'selector': 'enable', 'lang_key': $j.getInfo('enable',flt_lang)},
				{'selector': 'status', 'lang_key': $j.getInfo('status',flt_lang)},
			],
			'column_filters': {
				'enabled': false
			},
			'paging': {
				'enabled': false,
			},
			'options': {
				'ref_column': false,
				'sorting': false,
			},
			'default_columns':['id', 'name', 'realm', 'shortname', 'enable', 'status'],
			'search': { 'enabled': false },
			'format_fn': {
				'enable': enable_format_fn,
				'status': status_format_fn,
			},
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,_: new Date().getTime()},function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/user/kdc_user/list");
			}
		});
	}

	return {configure: configure};

})(jQuery);
