var module_list = (function($) {
	'use strict';
	function ssl_format_fn(td, col, row_data){
		var ssl = row_data[col.selector];
		var key = '';
		if(ssl == 'enable')
			key = 'enabled';
		else if(ssl == 'disable')
			key = 'disabled';
		return $j.getInfo(key, flt_lang);
	}

	function type_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];

		return data.split('').map(function(val, index){
			if(index == 0)
				return val.toUpperCase();
			else
				return val;
		});
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function gen_qlist(datas){		
		var settings = {
			'prefix': 'user_ldap_list',
			'source': datas,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name',flt_lang)},
				{'selector': 'server', 'lang_key': $j.getInfo('server_name',flt_lang)},
				{'selector': 'port', 'lang_key': $j.getInfo('port',flt_lang)},
				{'selector': 'common-name-id', 'lang_key': $j.getInfo('cn_id',flt_lang)},
				{'selector': 'distinguished-name', 'lang_key': $j.getInfo('dn',flt_lang)},
				{'selector': 'bind-type', 'lang_key': $j.getInfo('type',flt_lang)},
				{'selector': 'ssl-connection', 'lang_key': $j.getInfo('ssl',flt_lang)},
			],
			'column_filters': {
				'enabled': false
			},
			'default_columns':['id', 'name', 'server', 'port', 'common-name-id', 'distinguished-name'],
			'format_fn': {
				'ssl-connection': ssl_format_fn,
				'bind-type': type_format_fn
			},
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,_: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/user/ldap_user/list");
			}
		});
	}

	return {configure: configure};

})(jQuery);
