/*
 * user pki list
 * */
var module_list = (function($) {
    'use strict';

    var source;
	function setup_qlist()
	{
		$.ajax({
			'url': '/user/pki_user/list/json',
			'dataType': 'json',
			'success': function(response)
			{
				if(response.status == 1)
				{
					source = response.results;
					gen_qlist();
				}
				else if(response.status == 0)
					error_handler(response.msg_id, "/user/pki_user/list");
			},
			'cache': false
		});
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		var qlist_settings = {
			'prefix': 'userpki',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'ref', selector: 'ref'},
			],
		        'columns': [
				{'selector': 'seq', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
				{'selector': 'cacert', 'lang_key': $j.getInfo("cacert",flt_lang)},
				{'selector': 'subject', 'lang_key': $j.getInfo('subject', flt_lang)}
			],
			'default_columns': ['seq', 'name', 'cacert', 'subject'],
			'callbacks': {
				'load': content_loaded
			}   
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);
	}
	return {configure: setup_qlist};

})(jQuery);

