var module_list = (function($) {
	'use strict';

	var source;

	function setup_qlist(){
		$.ajax({
			'url': '/cli-direct-action?table_gid='+g_cmdb_table_id,
			'dataType': 'json',
			'success': function(response)
		{
			if(response.status == 1)
		{
			source = response.datas;
			gen_qlist();
		}
			else if(response.status == 0)
			error_handler(response.msg_id, "/user/radius_user/list");
		},
			'cache': false
		});
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function auth_type_format_fn($td, col, row_data)
	{
		var html = '';
		var type = row_data['auth-type_val'];

		if(type == 0)
			html = 'DEFAULT';
		else if(type == 1)
			html = 'CHAP';
		else if(type == 2)
			html = 'MS-CHAP';
		else if(type == 3)
			html = 'MS-CHAP-V2';
		else if(type == 4)
			html = 'PAP';

		return html;
	}

	function gen_qlist(){
		var qlist_settings = {
			'prefix': 'radius',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
				{'selector': 'server', 'lang_key': $j.getInfo("server_name",flt_lang)},
				{'selector': 'server-port', 'lang_key': $j.getInfo("port",flt_lang)},
				{'selector': 'secondary-server', 'lang_key': $j.getInfo('secondary_server_name', flt_lang)},
				{'selector': 'secondary-server-port', 'lang_key': $j.getInfo("secondary_port",flt_lang)},
				{'selector': 'auth-type', 'lang_key': $j.getInfo("auth_type", flt_lang)},
				{'selector': 'nas-ip', 'lang_key': $j.getInfo("nas_ip", flt_lang)}
			],
			'default_columns':['id', 'name', 'server', 'server-port', 'secondary-server', 'secondary-server-port'],
			'column_filters': {
				'enabled': false,
			},
			'format_fn': {
				'auth-type' : auth_type_format_fn,
			},
//			'handle_selection_change': selection_changed,
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);

	}

	return {configure: setup_qlist};

})(jQuery);
